/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.util.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class InvokeStackCache {
    private static final Logger logger = Logger.getLogger(InvokeStackCache.class);
    private final Stack stack = new Stack();
    private static ThreadLocal threadLocal = new ThreadLocal(){

        protected Object initialValue() {
            return new InvokeStackCache();
        }
    };

    private InvokeStackCache() {
    }

    public static InvokeStackCache getInstance() {
        InvokeStackCache thlCache = (InvokeStackCache)threadLocal.get();
        return thlCache;
    }

    public void enter() {
        this.stack.push(new HashMap());
    }

    public void exit() {
        ((Map)this.stack.pop()).clear();
    }

    public int depth() {
        return this.stack.size();
    }

    private Map getCurrentCache() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("call ThreadLocalCache.enter().");
        }
        return (Map)this.stack.peek();
    }

    public boolean containsKey(Object key) {
        return this.getCurrentCache().containsKey(key);
    }

    public Object get(Object key) {
        Object val;
        block3: {
            val = this.getCurrentCache().get(key);
            if (val == null) {
                return null;
            }
            try {
                val = ObjectUtils.createCopy(val);
            }
            catch (CloneNotSupportedException cne) {
                if (!logger.isDebugEnabled()) break block3;
                logger.info((Object)("CacheObject is not cloneable: " + key.toString()));
            }
        }
        return val;
    }

    public boolean isEmpty() {
        return this.getCurrentCache().isEmpty();
    }

    public Object put(Object key, Object value) {
        Object val;
        block3: {
            val = value;
            if (val != null) {
                try {
                    val = ObjectUtils.createCopy((Object)val);
                }
                catch (CloneNotSupportedException cne) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.info((Object)("CacheObject is not cloneable: " + key.toString()));
                }
            }
        }
        return this.getCurrentCache().put(key, val);
    }

    public Object remove(Object key) {
        return this.getCurrentCache().remove(key);
    }

    public int size() {
        return this.getCurrentCache().size();
    }

    public void clear() {
        this.getCurrentCache().clear();
    }
}

