/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.bos.rpcwrapper.ClientInvokeMonitor;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.bos.util.BOSObjectType;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class Utils {
    public static final String OBJECT_COLLECTIONS = "collections";
    public static final String REGION_OBJECTS = "EntitesObjects";
    public static final String REGION_QUERYRS = "QueryRs";
    public static final String ORMAPPING_MSG = "13357hjgy6856fghyer5476aw";
    private static final ClientInvokeMonitor monitor = new ClientInvokeMonitor();
    public static final BOSObjectType NULL_TYPE;

    private Utils() {
    }

    public static ClientInvokeMonitor getInvokeMonitor() {
        return monitor;
    }

    public static boolean isEntity(BOSObjectType bosType) {
        return MDContextFactory.getRemoteInstance().entityMapping.getProperty(bosType) != null;
    }

    public static BOSObjectType getBOSTypeFromEntityPK(IMetaDataPK entityPK) {
        return MDContextFactory.getRemoteInstance().entityMapping.getProperty(entityPK.getFullName());
    }

    public static BOSObjectType getBOSTypeFromQueryPK(IMetaDataPK queryPK, BOSObjectType defaultValue) {
        if (ConfigMDUtil.isClient()) {
            QuerySelect select = new QuerySelect(queryPK.getFullName());
            select.mainEntitySelect();
            try {
                SimpleEntity entity;
                SimpleQuery query = MetaDataAccessFactory.getRemoteInstance().select(select);
                if (query != null && (entity = query.mainEntity()) != null) {
                    return entity.getType();
                }
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
            return defaultValue;
        }
        return Utils.getBOSTypeFromQueryPK(ConfigMDUtil.getContext(), queryPK);
    }

    public static BOSObjectType getBOSTypeFromQueryPK(IMetaDataPK queryPK) {
        return Utils.getBOSTypeFromQueryPK(queryPK, NULL_TYPE);
    }

    public static BOSObjectType getBOSTypeFromQueryPK(Context ctx, IMetaDataPK queryPK, BOSObjectType defaultValue) {
        try {
            EntityObjectInfo entity;
            SubObjectInfo mainEntity;
            QueryInfo qi = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getQuery(queryPK);
            if (qi != null && (mainEntity = qi.getMainObject()) != null && mainEntity instanceof SubEntityInfo && (entity = ((SubEntityInfo)mainEntity).getEntityRef()) != null) {
                return entity.getType();
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static BOSObjectType getBOSTypeFromQueryPK(Context ctx, IMetaDataPK queryPK) {
        return Utils.getBOSTypeFromQueryPK(ctx, queryPK, NULL_TYPE);
    }

    public static String transMD5(String str) {
        StringBuffer buf = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] b = md.digest();
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String randomStr(String type) {
        String ret = "";
        SecureRandom rd = new SecureRandom();
        ret = type + String.valueOf(rd.nextInt());
        return ret;
    }

    static {
        RPCEngineFactory.addInvokeMonitor((InvokeMonitor)monitor);
        NULL_TYPE = BOSObjectType.create((String)"NULL");
    }
}

