/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.config;

import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.config.MethodIntent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CacheConfigManager {
    private static final int maxvals = 1;
    private static int numitems;
    private static final ICacheConfig[] configs;
    private static final ICacheConfig dummyCacheConfig;

    public static synchronized void registerConfig(ICacheConfig config) {
        assert (config != null);
        if (numitems < 1) {
            CacheConfigManager.configs[CacheConfigManager.numitems] = new InnerCacheConfig(config);
            ++numitems;
        }
    }

    public static synchronized ICacheConfig getConfig() {
        if (!GeniusBOSFactory.needCache()) {
            return dummyCacheConfig;
        }
        return configs[0];
    }

    public static ICacheConfig getInnerConfig() {
        return configs[0];
    }

    static {
        configs = new ICacheConfig[1];
        dummyCacheConfig = new DummyCacheConfig();
    }

    private static final class InnerCacheConfig
    implements ICacheConfig {
        private final ICacheConfig config;
        private final Map<Object, Boolean> needQueryCacheMap;
        private final Map<Object, MethodIntent> methodIntentMap;

        public InnerCacheConfig(ICacheConfig config) {
            this.config = config;
            this.needQueryCacheMap = new ConcurrentHashMap<Object, Boolean>();
            this.methodIntentMap = new ConcurrentHashMap<Object, MethodIntent>();
        }

        @Override
        public MethodIntent getMethodIntent(BOSObjectType bosType, Method mthd) {
            assert (bosType != null && !Utils.NULL_TYPE.equals((Object)bosType));
            MethodKey key = new MethodKey(bosType, mthd);
            MethodIntent intent = this.methodIntentMap.get(key);
            if (intent == null) {
                intent = this.innerGetMethodIntent(bosType, mthd);
                this.methodIntentMap.put(key, intent);
            }
            return intent;
        }

        private MethodIntent innerGetMethodIntent(BOSObjectType bosType, Method mthd) {
            MethodIntent intent = this.config.getMethodIntent(bosType, mthd);
            if (intent != null && !intent.equals((Object)MethodIntent.UNKNOWN)) {
                return intent;
            }
            if (Utils.isEntity(bosType)) {
                String mthdName = mthd.getName();
                if ("addnew".equals(mthdName) || "update".equals(mthdName) || "delete".equals(mthdName) || "submit".equals(mthdName) || "batchExecute".equals(mthdName) || "save".equals(mthdName) || "addnewBatchData".equals(mthdName) || "updateBatchData".equals(mthdName) || "saveBatchData".equals(mthdName) || "submitBatchData".equals(mthdName) || "deleteBatchData".equals(mthdName) || "batchingExecute".equals(mthdName) || "executeBackground".equals(mthdName) || "updatePartial".equals(mthdName) || "cancel".equals(mthdName) || "cancelCancel".equals(mthdName)) {
                    return MethodIntent.WRITE;
                }
                if ("exists".equals(mthdName) || "getPKList".equals(mthdName) || "getValue".equals(mthdName) || "getCollection".equals(mthdName)) {
                    return MethodIntent.GET;
                }
                if (this.isGetMethod(mthd)) {
                    return MethodIntent.GET;
                }
            }
            return MethodIntent.UNKNOWN;
        }

        private boolean isGetMethod(Method mthd) {
            String regEx = "^get.+(Info|Collection)$";
            Pattern p = Pattern.compile(regEx);
            Matcher m = p.matcher(mthd.getName());
            return m.find();
        }

        @Override
        public boolean needCache(BOSObjectType bosType) {
            if (bosType == null) {
                return false;
            }
            Boolean b = null;
            if (b == null) {
                b = bosType == null || Utils.NULL_TYPE.equals((Object)bosType) ? Boolean.FALSE : Boolean.valueOf(this.config.needCache(bosType));
            }
            return b;
        }

        @Override
        public boolean needCache(IMetaDataPK queryPk) {
            if (queryPk == null) {
                return false;
            }
            Boolean b = null;
            if (b == null) {
                b = Utils.NULL_TYPE.equals((Object)Utils.getBOSTypeFromQueryPK(queryPk)) ? Boolean.FALSE : Boolean.valueOf(this.config.needCache(queryPk));
            }
            return b;
        }

        @Override
        public boolean needQueryCache(BOSObjectType bosType) {
            if (bosType == null) {
                return false;
            }
            Boolean b = this.needQueryCacheMap.get(bosType);
            if (b == null) {
                b = bosType == null || Utils.NULL_TYPE.equals((Object)bosType) ? Boolean.FALSE : Boolean.valueOf(this.config.needQueryCache(bosType));
                this.needQueryCacheMap.put(bosType, b);
            }
            return b;
        }

        @Override
        public boolean needQueryCache(IMetaDataPK queryPk) {
            if (queryPk == null) {
                return false;
            }
            Boolean b = this.needQueryCacheMap.get(queryPk);
            if (b == null) {
                b = Utils.NULL_TYPE.equals((Object)Utils.getBOSTypeFromQueryPK(queryPk)) ? Boolean.FALSE : Boolean.valueOf(this.config.needQueryCache(queryPk));
                this.needQueryCacheMap.put(queryPk, b);
            }
            return b;
        }

        @Override
        public boolean needCache() {
            return this.config.needCache();
        }

        @Override
        public BOSObjectType getFacadeRealBosType(BOSObjectType bosType, Method mthod) {
            return this.config.getFacadeRealBosType(bosType, mthod);
        }

        @Override
        public boolean needServerCache() {
            return this.config.needServerCache();
        }

        @Override
        public void setServerCache(boolean isValid) {
            this.config.setServerCache(isValid);
        }

        @Override
        public String[] getMemcacheServerList() {
            return this.config.getMemcacheServerList();
        }

        @Override
        public int getMemcacheHashAlg() {
            return this.config.getMemcacheHashAlg();
        }

        @Override
        public Map getStoreLevelMap() {
            return this.config.getStoreLevelMap();
        }

        @Override
        public boolean isCreateByClient() {
            return this.config.isCreateByClient();
        }

        @Override
        public boolean isIgnoreException() {
            return this.config.isIgnoreException();
        }

        @Override
        public String getOuterCacheServerType() {
            return this.config.getOuterCacheServerType();
        }

        @Override
        public String[] getOuterEhcacheServerList() {
            return this.config.getOuterEhcacheServerList();
        }

        @Override
        public boolean needOrmOuterCache(String bosType) {
            return this.config.needOrmOuterCache(bosType);
        }

        @Override
        public boolean isOrmCloneWhenGetCache(String bosType) {
            return this.config.isOrmCloneWhenGetCache(bosType);
        }

        private static final class MethodKey {
            private final BOSObjectType bosType;
            private final Method mthd;

            public MethodKey(BOSObjectType bosType, Method mthd) {
                assert (bosType != null);
                assert (mthd != null);
                this.bosType = bosType;
                this.mthd = mthd;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof MethodKey)) {
                    return false;
                }
                MethodKey that = (MethodKey)o;
                return this.bosType.equals((Object)that.bosType) && this.mthd.equals(that.mthd);
            }

            public int hashCode() {
                int hash = this.bosType.toString().hashCode();
                hash += 31 * this.mthd.hashCode();
                Class<?>[] params = this.mthd.getParameterTypes();
                int n = params.length;
                for (int i = 0; i < n; ++i) {
                    hash += 31 * params[i].hashCode();
                }
                return hash;
            }
        }
    }

    private static final class DummyCacheConfig
    implements ICacheConfig {
        private DummyCacheConfig() {
        }

        @Override
        public BOSObjectType getFacadeRealBosType(BOSObjectType bosType, Method mthd) {
            return null;
        }

        @Override
        public MethodIntent getMethodIntent(BOSObjectType bosType, Method mthd) {
            return null;
        }

        @Override
        public boolean needCache(BOSObjectType bosType) {
            return false;
        }

        @Override
        public boolean needCache() {
            return false;
        }

        @Override
        public boolean needServerCache() {
            return false;
        }

        @Override
        public void setServerCache(boolean isValid) {
        }

        @Override
        public String[] getMemcacheServerList() {
            return null;
        }

        @Override
        public Map getStoreLevelMap() {
            return null;
        }

        @Override
        public int getMemcacheHashAlg() {
            return 0;
        }

        @Override
        public boolean needCache(IMetaDataPK queryPk) {
            return false;
        }

        @Override
        public boolean needQueryCache(BOSObjectType bosType) {
            return false;
        }

        @Override
        public boolean needQueryCache(IMetaDataPK queryPk) {
            return false;
        }

        @Override
        public boolean isCreateByClient() {
            return false;
        }

        @Override
        public boolean isIgnoreException() {
            return true;
        }

        @Override
        public String getOuterCacheServerType() {
            return null;
        }

        @Override
        public String[] getOuterEhcacheServerList() {
            return null;
        }

        @Override
        public boolean needOrmOuterCache(String bosType) {
            return false;
        }

        @Override
        public boolean isOrmCloneWhenGetCache(String bosType) {
            return false;
        }
    }
}

