/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.notify;

import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.bos.sql.shell.trace.LoggerDest;
import com.kingdee.bos.util.BOSObjectType;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CacheCleanByTable
implements LoggerDest {
    public static final Logger logger = Logger.getLogger((String)CacheCleanByTable.class.getName());
    private static HashSet globalTypeSet = new HashSet();
    private static ThreadLocal threadTypeSet = new ThreadLocal(){

        protected Object initialValue() {
            return new HashSet();
        }
    };
    private static CustomCacheService cacheService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        boolean isCache = CacheConfigManager.getConfig().needCache();
        if (!isCache) {
            return;
        }
        cacheService = new CustomCacheService("cache.tableToType");
        String deploy = System.getProperty("eas.deploy");
        String propFile = deploy + "/table2type.properties";
        Properties prop = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propFile);
            prop.load(fis);
        }
        catch (IOException e) {
            logger.warn((Object)("cannot load table2type file " + propFile));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        Enumeration<Object> keyEnum = prop.keys();
        while (keyEnum.hasMoreElements()) {
            String tableName = (String)keyEnum.nextElement();
            String typeSetStr = prop.getProperty(tableName);
            if (tableName == null || typeSetStr == null) continue;
            HashSet<String> typeSet = new HashSet<String>();
            String subStr = typeSetStr.substring(1, typeSetStr.length() - 1);
            StringTokenizer token = new StringTokenizer(subStr, ",");
            while (token.hasMoreTokens()) {
                String type = token.nextToken().trim();
                typeSet.add(type);
            }
            if (typeSet.size() <= 0) continue;
            cacheService.put(tableName, typeSet);
        }
        CacheCleanByTable monitor = new CacheCleanByTable();
        ConnectionLogger.addLoggerDest((LoggerDest)monitor);
    }

    public void log(LogItem logitem) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sql2BosType(String sql) {
        if (sql == null) {
            return;
        }
        String tablename = null;
        StringTokenizer token = new StringTokenizer(sql);
        if (sql.startsWith("INSERT")) {
            token.nextToken();
            token.nextToken();
            tablename = token.nextToken().toUpperCase();
        } else if (sql.startsWith("UPDATE")) {
            token.nextToken();
            tablename = token.nextToken().toUpperCase();
        } else if (sql.startsWith("DELETE")) {
            token.nextToken();
            token.nextToken();
            tablename = token.nextToken().toUpperCase();
        } else if (sql.startsWith("TRUNCATE")) {
            token.nextToken();
            token.nextToken();
            tablename = token.nextToken().toUpperCase();
        } else {
            return;
        }
        HashSet tmpSet = new HashSet();
        if ("T_PM_USER".equalsIgnoreCase(tablename)) {
            tmpSet.add("13B7DE7F");
        } else {
            tmpSet = (HashSet)cacheService.get(tablename);
        }
        HashSet typeSet = (HashSet)threadTypeSet.get();
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config != null && config.needServerCache() && tmpSet != null && tmpSet.size() > 0) {
            ICacheService svc = CacheServiceFactory.getInstance();
            for (String type : tmpSet) {
                BOSObjectType bosType = BOSObjectType.create((String)type);
                svc.discardType(bosType);
            }
        }
        if (tmpSet != null && typeSet != null) {
            typeSet.addAll(tmpSet);
            HashSet hashSet = globalTypeSet;
            synchronized (hashSet) {
                globalTypeSet.addAll(tmpSet);
            }
        }
    }

    public static HashSet getThreadTypeSet() {
        HashSet typeSet = (HashSet)threadTypeSet.get();
        HashSet re = new HashSet(typeSet);
        typeSet.clear();
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet getGlobalTypeSet() {
        HashSet re;
        HashSet hashSet = globalTypeSet;
        synchronized (hashSet) {
            re = new HashSet(globalTypeSet);
            globalTypeSet.clear();
        }
        return re;
    }
}

