/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.notify;

import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.notify.ICacheUpdateInfoRequestor;
import com.kingdee.bos.framework.cache.notify.RemoteCacheUpdateInfoRequestor;
import com.kingdee.bos.util.BOSObjectType;
import org.apache.log4j.Logger;

public class CacheCleanClientTreat {
    private static Logger logger = Logger.getLogger(CacheCleanClientTreat.class);
    private static String sessionId = "";

    public static void registerSessionId(String id) {
        sessionId = id;
    }

    public static void receiveCacheClean() {
        try {
            if (sessionId == null || sessionId.equals("")) {
                return;
            }
            ICacheUpdateInfoRequestor remoteCacheUpdate = RemoteCacheUpdateInfoRequestor.getRemoteInstance();
            Boolean obj = remoteCacheUpdate.getSessionCacheClean(sessionId);
            boolean isClean = false;
            if (obj != null) {
                isClean = obj;
            }
            ICacheService cache = CacheServiceFactory.getInstance();
            if (isClean) {
                cache.discardAll();
            } else {
                BOSObjectType[] types = remoteCacheUpdate.getSessionCacheMethod(sessionId);
                if (types != null) {
                    int n = types.length;
                    for (int i = 0; i < n; ++i) {
                        cache.discardType(types[i]);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }
}

