/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.notify;

import com.kingdee.bos.db.RepositoryFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.notify.CacheCleanByTable;
import com.kingdee.bos.framework.session.SessionInfo;
import com.kingdee.bos.framework.session.SessionManager;
import com.kingdee.bos.rpc.InvokeIntercepter;
import com.kingdee.bos.rpc.impl.RPCSessionImpl;
import com.kingdee.bos.rpc.impl.ServerSessionImpl;
import com.kingdee.bos.rpc.performance.InvokeRecord;
import com.kingdee.bos.sql.shell.Repository;
import com.kingdee.bos.util.BOSObjectType;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class RPCInvokeCacheIntercepter
implements InvokeIntercepter {
    private static final Logger logger = Logger.getLogger(RPCInvokeCacheIntercepter.class);
    public static final RPCInvokeCacheIntercepter INSTANCE = new RPCInvokeCacheIntercepter();

    private RPCInvokeCacheIntercepter() {
    }

    public void finishInvoke(RPCSessionImpl session, ObjectInput in, int type, Object result, InvokeRecord.MethodInvoke method) throws IOException {
        if (type != 1) {
            Object object = null;
            try {
                object = in.readObject();
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"", (Throwable)e);
            }
            catch (EOFException e) {
                logger.debug((Object)"no Intercepter data");
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
            }
            if (object != null) {
                if (object instanceof Boolean) {
                    CacheServiceFactory.getInstance().discardAll();
                    logger.debug((Object)"Invoke discard all Cache");
                } else if (object instanceof BOSObjectType[]) {
                    BOSObjectType[] types = (BOSObjectType[])object;
                    int n = types.length;
                    for (int i = 0; i < n; ++i) {
                        CacheServiceFactory.getInstance().discardType(types[i]);
                        logger.debug((Object)("Invoke discard all Cache [" + types[i] + "]"));
                    }
                }
            }
            try {
                String ais;
                boolean query = in.readBoolean();
                if (query && !"I".equals(ais = in.readUTF())) {
                    if (method != null) {
                        method.repository = ais;
                    } else {
                        RepositoryFactory.getLogger().info((Object)("dispatched to " + ais));
                    }
                }
            }
            catch (EOFException e) {
                logger.debug((Object)"no Intercepter data");
            }
        }
    }

    public void keepAlive(RPCSessionImpl session, ObjectInput in) throws IOException {
        Object object = null;
        try {
            object = in.readObject();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (EOFException e) {
            logger.debug((Object)"no Intercepter data");
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (object != null) {
            if (object instanceof Boolean) {
                logger.debug((Object)"keepAlive discard all Cache");
                CacheServiceFactory.getInstance().discardAll();
            } else if (object instanceof BOSObjectType[]) {
                BOSObjectType[] types = (BOSObjectType[])object;
                int n = types.length;
                for (int i = 0; i < n; ++i) {
                    CacheServiceFactory.getInstance().discardType(types[i]);
                    logger.debug((Object)("keepAlive discard all Cache [" + types[i] + "]"));
                }
            }
        }
    }

    public void serviceInvoke(ServerSessionImpl session, ObjectOutput out) throws IOException {
        Object bosSessionId = session.getContext((Object)"bos_sessionid");
        SessionInfo sessionInfo = SessionManager.getInstance().getSession(bosSessionId == null ? "" : bosSessionId.toString());
        Boolean isCleanAll = null;
        List bostypeList = null;
        if (sessionInfo != null) {
            isCleanAll = (Boolean)sessionInfo.get((Object)"CLEANCACHE");
            bostypeList = (List)sessionInfo.get((Object)"CLEANMETHOD");
        }
        if (isCleanAll != null) {
            sessionInfo.remove((Object)"CLEANCACHE");
            out.writeObject(isCleanAll);
        } else {
            HashSet typeSet = CacheCleanByTable.getThreadTypeSet();
            if (bostypeList != null) {
                sessionInfo.remove((Object)"CLEANMETHOD");
                typeSet.addAll(bostypeList);
            }
            out.writeObject(this.toBOSObjectTypeArray(typeSet));
        }
        Repository repo = RepositoryFactory.getCurrentRepository();
        if (repo == null || repo.getResponsibility().isCommand()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            String ais = repo.getIdentity();
            if (ais == null) {
                ais = "I";
            }
            out.writeUTF(ais);
        }
    }

    public void serviceKeepAlive(ServerSessionImpl session, ObjectOutput out) throws IOException {
        String bosSessionId = (String)session.getContext((Object)"bos_sessionid");
        if (bosSessionId != null) {
            SessionInfo sessionInfo = SessionManager.getInstance().getSession(bosSessionId);
            Boolean isCleanAll = null;
            List bostypeList = null;
            if (sessionInfo != null) {
                isCleanAll = (Boolean)sessionInfo.get((Object)"CLEANCACHE");
                bostypeList = (List)sessionInfo.get((Object)"CLEANMETHOD");
            }
            if (isCleanAll != null) {
                sessionInfo.remove((Object)"CLEANCACHE");
                out.writeObject(isCleanAll);
            } else {
                HashSet typeSet = new HashSet();
                if (bostypeList != null) {
                    typeSet.addAll(bostypeList);
                    sessionInfo.remove((Object)"CLEANMETHOD");
                }
                out.writeObject(this.toBOSObjectTypeArray(typeSet));
            }
        }
    }

    private final BOSObjectType[] toBOSObjectTypeArray(HashSet typeSet) {
        BOSObjectType[] types = null;
        if (typeSet.size() > 0) {
            String[] typeList = typeSet.toArray(new String[0]);
            types = new BOSObjectType[typeList.length];
            int n = types.length;
            for (int i = 0; i < n; ++i) {
                types[i] = BOSObjectType.create((String)typeList[i]);
            }
        }
        return types;
    }
}

