/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service;

import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.bos.framework.cache.service.RPCClientUtils;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheOuterUtils;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheService;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheServiceWraper;
import com.kingdee.bos.framework.cache.service.memcache.MemcacheService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class CacheRouterManager {
    private static Logger log = Logger.getLogger((String)CacheRouterManager.class.getName());
    private AtomicBoolean isLoadConfig = new AtomicBoolean(false);
    private ConcurrentHashMap<String, Map<String, String>> cacheConfig = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> cacheRoutersConfigStatus = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> cacheRoutersAddress = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConcurrentHashMap<String, Object>> cacheRouters = new ConcurrentHashMap<String, ConcurrentHashMap<String, Object>>(){

        @Override
        public ConcurrentHashMap<String, Object> get(Object key) {
            ConcurrentHashMap obj = (ConcurrentHashMap)super.get(key);
            if (obj != null) {
                return obj;
            }
            ConcurrentHashMap<String, Object> routerMap = null;
            ICacheRouter customRouter = null;
            int customRouterType = 1;
            String type = "";
            if (key == null) {
                return null;
            }
            type = key.toString();
            Map customCacheMap = (Map)CacheRouterManager.this.cacheConfig.get("customCacheConfigMap");
            String storeLevel = customCacheMap == null ? null : (String)customCacheMap.get(type);
            CacheRouterManager.this.isCustomRouterConfigStatusChanged(type, true);
            if (storeLevel != null) {
                if (storeLevel.equals("1")) {
                    HashSet<String> remoteCacheConnList = MemcacheService.getInstance().getMemcacheServerLiveList();
                    if (EhcacheOuterUtils.isEhcacheOuter() && EhcacheOuterUtils.getEhcacheServerListAlive() != null && EhcacheOuterUtils.getEhcacheServerListAlive().length > 0) {
                        customRouter = new EhcacheServiceWraper(RPCClientUtils.getBean(ICacheRouter.class));
                        customRouterType = 1;
                        CacheRouterManager.this.cacheRoutersAddress.put(type, EhcacheOuterUtils.getEhcacheServerListAlive()[0]);
                    } else if (remoteCacheConnList != null && remoteCacheConnList.size() != 0) {
                        customRouter = MemcacheService.getInstance();
                        customRouterType = 1;
                    } else {
                        boolean autoDegrade = false;
                        Object autoDegradeObj = customCacheMap.get(type + ".autoDegrade");
                        if (autoDegradeObj != null && autoDegradeObj.equals("1")) {
                            autoDegrade = true;
                        }
                        if (autoDegrade) {
                            customRouter = EhcacheService.getInstance();
                            customRouterType = 0;
                        } else {
                            customRouter = null;
                        }
                    }
                } else if (storeLevel.equals("0")) {
                    customRouter = EhcacheService.getInstance();
                    customRouterType = 0;
                }
                if (customRouter != null) {
                    routerMap = new ConcurrentHashMap<String, Object>();
                    routerMap.put(type + ".cacheRouter", customRouter);
                    routerMap.put(type + ".cacheRouterType", customRouterType);
                    this.put(type, routerMap);
                }
            }
            return routerMap;
        }
    };
    public static Set<String> missedCustomRouterSet = Collections.synchronizedSet(new HashSet());

    private CacheRouterManager() {
        this.initRouter();
    }

    private void initRouter() {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config == null) {
            this.isLoadConfig.set(false);
        } else {
            this.isLoadConfig.set(true);
        }
        if (config != null && !config.isCreateByClient()) {
            Map customCacheMap = config.getStoreLevelMap();
            if (customCacheMap != null) {
                this.cacheConfig.put("customCacheConfigMap", customCacheMap);
            }
            CacheSwitchThread cacheSwitchThread = new CacheSwitchThread();
            cacheSwitchThread.start();
        }
    }

    public static CacheRouterManager getInstance() {
        return SingletonHolder.instance;
    }

    private boolean isCustomRouterConfigStatusChanged(String type, boolean init) {
        Map<String, String> customCacheMap = this.cacheConfig.get("customCacheConfigMap");
        if (customCacheMap == null) {
            return false;
        }
        if (init && this.cacheRoutersConfigStatus.contains(type)) {
            return false;
        }
        StringBuffer configStr = new StringBuffer();
        configStr.append(customCacheMap.get(type));
        configStr.append(customCacheMap.get(type + ".autoDegrade"));
        configStr.append(customCacheMap.get(type + ".eternal"));
        configStr.append(customCacheMap.get(type + ".maxElements"));
        configStr.append(customCacheMap.get(type + ".timeToIdleSeconds"));
        configStr.append(customCacheMap.get(type + ".timeToLiveSeconds"));
        configStr.append(customCacheMap.get(type + ".supportDisk"));
        if (this.cacheRoutersConfigStatus.contains(type)) {
            if (configStr.toString().equals(this.cacheRoutersConfigStatus.get(type))) {
                return false;
            }
            this.cacheRoutersConfigStatus.put(type, configStr.toString());
            return true;
        }
        this.cacheRoutersConfigStatus.put(type, configStr.toString());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentHashMap<String, Object> getRouterMap(String type) {
        if (!this.isLoadConfig.get()) {
            CacheRouterManager cacheRouterManager = this;
            synchronized (cacheRouterManager) {
                if (!this.isLoadConfig.get()) {
                    this.initRouter();
                }
            }
        }
        return this.cacheRouters.get(type);
    }

    public ICacheRouter getCustomRouter(String type) {
        ConcurrentHashMap<String, Object> routerMap = this.getRouterMap(type);
        if (routerMap == null) {
            missedCustomRouterSet.add(type);
            return null;
        }
        Object cacheRouter = routerMap.get(type + ".cacheRouter");
        if (cacheRouter == null) {
            missedCustomRouterSet.add(type);
        }
        return (ICacheRouter)cacheRouter;
    }

    public int getCustomRouterType(String type) {
        ConcurrentHashMap<String, Object> routerMap = this.getRouterMap(type);
        if (routerMap == null) {
            return 1;
        }
        Object customRouterType = routerMap.get(type + ".cacheRouterType");
        if (customRouterType == null) {
            return 1;
        }
        return (Integer)customRouterType;
    }

    public Map<String, String> getCustomCacheConfig() {
        return this.cacheConfig.get("customCacheConfigMap");
    }

    class CacheSwitchThread
    extends Thread {
        CacheSwitchThread() {
            super("CacheSwitchThread");
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(30000L);
                        this.handlerCacheSwitch();
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"CacheSwitchThread error !", e);
                    continue;
                }
                break;
            }
        }

        public void handlerCacheSwitch() {
            Iterator itr = CacheRouterManager.this.cacheRouters.entrySet().iterator();
            Map customCacheMap = (Map)CacheRouterManager.this.cacheConfig.get("customCacheConfigMap");
            if (customCacheMap == null || customCacheMap.size() == 0) {
                return;
            }
            String cacheType = null;
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                String type = (String)entry.getKey();
                ConcurrentHashMap routerMap = (ConcurrentHashMap)entry.getValue();
                Object customRouter = routerMap.get(type + ".cacheRouter");
                cacheType = (String)customCacheMap.get(type);
                if (cacheType == null || !cacheType.equals("1")) continue;
                if (CacheRouterManager.this.isCustomRouterConfigStatusChanged(type, false)) {
                    CacheRouterManager.this.cacheRouters.remove(type);
                    if (customRouter == null || !(customRouter instanceof EhcacheService)) continue;
                    EhcacheService.getInstance().removeCacheRegion(type);
                    continue;
                }
                HashSet<String> remoteCacheConnList = MemcacheService.getInstance().getMemcacheServerLiveList();
                if (EhcacheOuterUtils.isEhcacheOuter() && EhcacheOuterUtils.getEhcacheServerListAlive() != null && EhcacheOuterUtils.getEhcacheServerListAlive().length > 0) {
                    if (!(customRouter instanceof EhcacheService) && !(customRouter instanceof MemcacheService) && !(customRouter instanceof EhcacheServiceWraper)) continue;
                    if (customRouter != null && customRouter instanceof EhcacheService) {
                        EhcacheService.getInstance().removeCacheRegion(type);
                    }
                    if (customRouter instanceof EhcacheServiceWraper && CacheRouterManager.this.cacheRoutersAddress.get(type) != null && EhcacheOuterUtils.getEhcacheServerListAlive()[0].equals(CacheRouterManager.this.cacheRoutersAddress.get(type))) continue;
                    ConcurrentHashMap<String, Object> newRouterMap = new ConcurrentHashMap<String, Object>();
                    newRouterMap.put(type + ".cacheRouter", new EhcacheServiceWraper(RPCClientUtils.getBean(ICacheRouter.class)));
                    newRouterMap.put(type + ".cacheRouterType", 1);
                    CacheRouterManager.this.cacheRouters.put(type, newRouterMap);
                    CacheRouterManager.this.cacheRoutersAddress.put(type, EhcacheOuterUtils.getEhcacheServerListAlive()[0]);
                    continue;
                }
                if (remoteCacheConnList != null && remoteCacheConnList.size() != 0) {
                    if (customRouter != null && customRouter instanceof EhcacheService) {
                        EhcacheService.getInstance().removeCacheRegion(type);
                    }
                    ConcurrentHashMap<String, Object> newRouterMap = new ConcurrentHashMap<String, Object>();
                    newRouterMap.put(type + ".cacheRouter", MemcacheService.getInstance());
                    newRouterMap.put(type + ".cacheRouterType", 1);
                    CacheRouterManager.this.cacheRouters.put(type, newRouterMap);
                    continue;
                }
                boolean autoDegrade = false;
                Object autoDegradeObj = customCacheMap.get(type + ".autoDegrade");
                if (autoDegradeObj != null && autoDegradeObj.equals("1")) {
                    autoDegrade = true;
                }
                if (autoDegrade) {
                    if (!(customRouter instanceof MemcacheService) && !(customRouter instanceof EhcacheServiceWraper)) continue;
                    ConcurrentHashMap<String, Object> newRouterMap = new ConcurrentHashMap<String, Object>();
                    newRouterMap.put(type + ".cacheRouter", EhcacheService.getInstance());
                    newRouterMap.put(type + ".cacheRouterType", 0);
                    CacheRouterManager.this.cacheRouters.put(type, newRouterMap);
                    continue;
                }
                CacheRouterManager.this.cacheRouters.remove(type);
            }
        }
    }

    private static class SingletonHolder {
        private static CacheRouterManager instance = new CacheRouterManager();

        private SingletonHolder() {
        }
    }
}

