/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service;

import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.bos.framework.cache.service.ICacheRouterOrmAdpter;
import com.kingdee.bos.framework.cache.service.RPCClientUtils;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheService;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheServiceWraper;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CacheRouterUtils {
    public static final Logger logger = Logger.getLogger((String)CacheRouterUtils.class.getName());

    public static ICacheRouter getOutEhcahceRouter() {
        return new EhcacheServiceWraper(RPCClientUtils.getBean(ICacheRouter.class));
    }

    public static ICacheRouter getLocalEhcahceRouter() {
        return EhcacheService.getInstance();
    }

    public static ICacheRouter getRemoteEhcahceRouter(String url) {
        if (StringUtils.isEmpty((String)url) || CacheRouterUtils.isLocal(url)) {
            return null;
        }
        ICacheRouterOrmAdpter cr = null;
        try {
            cr = (ICacheRouterOrmAdpter)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.bos.framework.cache.service.ehcache.EhcacheServiceOrmAdpter", ICacheRouterOrmAdpter.class);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return cr;
    }

    public static List<String> getRemoteServerList() {
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return null;
        }
        IRPCServer[] ss = sv.getServers();
        ArrayList<String> ls = new ArrayList<String>();
        for (int i = 0; i < ss.length; ++i) {
            String url;
            IRPCServer s = ss[i];
            if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || CacheRouterUtils.isLocal(url)) continue;
            ls.add(url);
        }
        return ls;
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }
}

