/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.ICustomCacheService;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.framework.cache.service.CacheRouterManager;
import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheService;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.Identity;

public class CacheService
implements ICacheService,
ICustomCacheService {
    private ICacheRouter responseInvokeRouter = EhcacheService.getInstance();
    private long maxSize = 0x4000000L;

    public static CacheService getInstance() {
        return new CacheService();
    }

    private ICacheRouter getCustomRouter(String type) {
        return CacheRouterManager.getInstance().getCustomRouter(type);
    }

    private int getCustomRouterType(String type) {
        return CacheRouterManager.getInstance().getCustomRouterType(type);
    }

    @Override
    public boolean contains(String type, String key) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return false;
        }
        return customRouter.isInCache(this.getTypeByAis(type), key);
    }

    @Override
    public void remove(String type, String key) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        customRouter.removeCache(this.getTypeByAis(type), key);
    }

    @Override
    public void remove(String type, String key, boolean realRemove) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        int customRouterType = this.getCustomRouterType(type);
        if (realRemove || customRouterType == 0) {
            customRouter.removeCache(this.getTypeByAis(type), key);
        }
    }

    @Override
    public void removeAll(String type) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        customRouter.removeCacheRegion(this.getTypeByAis(type));
    }

    @Override
    public Object get(String type, String key) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return null;
        }
        return customRouter.getCache(this.getTypeByAis(type), key, false);
    }

    @Override
    public void put(String type, String key, Object obj) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        customRouter.putCache(this.getTypeByAis(type), key, obj, 0L);
    }

    private String getBosTypeByAis(BOSObjectType bosType) {
        StringBuffer aisName = new StringBuffer("");
        aisName.append(ConfigMDUtil.getAIS());
        aisName.append("#").append(bosType.toString());
        return aisName.toString();
    }

    private String getTypeByAis(String type) {
        StringBuffer aisName = new StringBuffer("");
        if (!type.startsWith("cache.tableToType")) {
            aisName.append(ConfigMDUtil.getAIS());
        }
        aisName.append("#").append(type);
        return aisName.toString();
    }

    private String getTypeByAis(String aix, String type) {
        StringBuffer aisName = new StringBuffer("");
        if (!type.startsWith("cache.tableToType")) {
            aisName.append(aix);
        }
        aisName.append("#").append(type);
        return aisName.toString();
    }

    public void removeAll(String ais, String type) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        StringBuffer tmpStr = new StringBuffer(ais);
        tmpStr.append("#").append(type);
        customRouter.removeCacheRegion(tmpStr.toString());
    }

    public void remove(String ais, String type, String key) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        StringBuffer tmpStr = new StringBuffer(ais);
        tmpStr.append("#").append(type);
        customRouter.removeCache(tmpStr.toString(), key);
    }

    @Override
    public boolean contains(BOSObjectType bosType, MultiParamKey key) {
        return this.responseInvokeRouter.isInCache(this.getBosTypeByAis(bosType) + "#" + "EntitesObjects", key.toString());
    }

    @Override
    public boolean containsObjectCollection(BOSObjectType bosType) {
        return this.responseInvokeRouter.isInCache(this.getBosTypeByAis(bosType), "collections");
    }

    @Override
    public boolean containsObjectValue(BOSObjectType bosType, Object objPk) {
        return this.responseInvokeRouter.isInCache(this.getBosTypeByAis(bosType) + "#" + "EntitesObjects", objPk.toString());
    }

    @Override
    public void discardAll() {
        this.responseInvokeRouter.removeAllCache();
    }

    @Override
    public void discardQuery(IMetaDataPK queryPk) {
        this.responseInvokeRouter.removeCacheRegion(this.getBosTypeByAis(Utils.getBOSTypeFromQueryPK(queryPk)), "QueryRs");
    }

    @Override
    public void discardQuery(BOSObjectType bosType) {
        this.responseInvokeRouter.removeCacheRegion(this.getBosTypeByAis(bosType), "QueryRs");
    }

    @Override
    public void discardType(BOSObjectType bosType) {
        this.responseInvokeRouter.removeCacheRegion(this.getBosTypeByAis(bosType));
    }

    @Override
    public Object get(BOSObjectType bosType, MultiParamKey key) {
        return this.responseInvokeRouter.getCache(this.getBosTypeByAis(bosType) + "#" + "EntitesObjects", key.toString(), true);
    }

    @Override
    public Object getQueryRsValue(BOSObjectType bosType, MultiParamKey key) {
        return this.responseInvokeRouter.getCache(this.getBosTypeByAis(bosType) + "#" + "QueryRs", key.toString(), true);
    }

    @Override
    public IObjectCollection getObjectCollection(BOSObjectType bosType) {
        return (IObjectCollection)this.responseInvokeRouter.getCache(this.getBosTypeByAis(bosType), "collections", true);
    }

    @Override
    public IObjectValue getObjectValue(BOSObjectType bosType, Object objPk) {
        return (IObjectValue)this.responseInvokeRouter.getCache(this.getBosTypeByAis(bosType) + "#" + "EntitesObjects", objPk.toString(), true);
    }

    @Override
    public void put(BOSObjectType bosType, MultiParamKey key, Object obj, long objSize) {
        this.responseInvokeRouter.putCache(this.getBosTypeByAis(bosType) + "#" + "EntitesObjects", key.toString(), obj, objSize);
    }

    @Override
    public void putObjectCollection(BOSObjectType bosType, IObjectCollection objCol, long objSize) {
        if (objCol != null && objCol.size() > 0) {
            int size = objCol.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue objVal = objCol.getObject(i);
                if (!(objVal instanceof Identity)) continue;
                this.putObjectValue(bosType, ((Identity)objVal).getIdentity(), objVal, 0L);
            }
        }
        this.responseInvokeRouter.putCache(this.getBosTypeByAis(bosType) + "#" + "EntitesObjects", "collections", objCol, objSize);
    }

    @Override
    public void putObjectValue(BOSObjectType bosType, Object objPk, IObjectValue objVal, long objSize) {
        this.responseInvokeRouter.putCache(this.getBosTypeByAis(bosType) + "#" + "EntitesObjects", objPk.toString(), objVal, objSize);
    }

    @Override
    public boolean containsQueryRsValue(BOSObjectType bosType, MultiParamKey key) {
        return this.responseInvokeRouter.isInCache(this.getBosTypeByAis(bosType) + "#" + "QueryRs", key.toString());
    }

    @Override
    public void putQueryRsValue(BOSObjectType bosType, MultiParamKey key, Object obj, long objSize) {
        this.responseInvokeRouter.putCache(this.getBosTypeByAis(bosType) + "#" + "QueryRs", key.toString(), obj, objSize);
    }

    @Override
    public boolean containsObjectValue(BOSObjectType bosType, Object objPk, MultiParamKey key) {
        return false;
    }

    @Override
    public void putObjectValue(BOSObjectType bosType, Object objPk, MultiParamKey key, IObjectValue objVal, long objSize) {
    }

    @Override
    public IObjectValue getObjectValue(BOSObjectType bosType, Object objPk, MultiParamKey key) {
        return null;
    }

    @Override
    public boolean containsByAix(String aix, String type, String key) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return false;
        }
        return customRouter.isInCacheByAix(aix, type, key);
    }

    @Override
    public void putByAix(String aix, String type, String key, Object obj) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        customRouter.putCacheByAix(aix, type, key, obj, 0L);
    }

    @Override
    public Object getByAix(String aix, String type, String key) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return null;
        }
        return customRouter.getCacheByAix(aix, type, key, false);
    }

    @Override
    public void removeByAix(String aix, String type, String key, boolean realRemove) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        int customRouterType = this.getCustomRouterType(type);
        if (realRemove || customRouterType == 0) {
            customRouter.removeCacheByAix(aix, type, key);
        }
    }

    @Override
    public void removeByAix(String aix, String type, String key) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        customRouter.removeCacheByAix(aix, type, key);
    }

    @Override
    public long getReadNum() {
        long readNum = 0L;
        if (this.responseInvokeRouter != null) {
            readNum = this.responseInvokeRouter.getReadNum();
        }
        return readNum;
    }

    @Override
    public long getTotalSize() {
        long totalSize = 0L;
        if (this.responseInvokeRouter != null) {
            totalSize = this.responseInvokeRouter.getTotalSize();
        }
        return totalSize;
    }

    @Override
    public long getDiscardAllNum() {
        long discardAllNum = 0L;
        if (this.responseInvokeRouter != null) {
            discardAllNum = this.responseInvokeRouter.getDiscardAllNum();
        }
        return discardAllNum;
    }

    @Override
    public long getDiscardRegionNum() {
        long discardRegionNum = 0L;
        if (this.responseInvokeRouter != null) {
            discardRegionNum = this.responseInvokeRouter.getDiscardRegionNum();
        }
        return discardRegionNum;
    }

    @Override
    public long getHitNum() {
        long hitNum = 0L;
        if (this.responseInvokeRouter != null) {
            hitNum = this.responseInvokeRouter.getHitNum();
        }
        return hitNum;
    }

    @Override
    public long getItemCount() {
        long itemCount = 0L;
        if (this.responseInvokeRouter != null) {
            itemCount = this.responseInvokeRouter.getItemCount();
        }
        return itemCount;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(long size) {
        this.maxSize = size;
    }

    @Override
    public void hset(String type, String key, String field, Object obj) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        customRouter.HSET(ConfigMDUtil.getAIS(), type, key, field, obj);
    }

    @Override
    public Object hget(String type, String key, String field) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return null;
        }
        return customRouter.HGET(ConfigMDUtil.getAIS(), type, key, field);
    }

    @Override
    public void hdel(String type, String key) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        customRouter.HDEL(ConfigMDUtil.getAIS(), type, key);
    }

    @Override
    public void hdel(String type, String key, String field) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        customRouter.HDEL(ConfigMDUtil.getAIS(), type, key, field);
    }

    @Override
    public void removeLocal(String type, String key) {
        ICacheRouter customRouter = this.getCustomRouter(type);
        if (customRouter == null) {
            return;
        }
        if (customRouter instanceof EhcacheService) {
            ((EhcacheService)customRouter).removeLocal(this.getTypeByAis(type), key);
        }
    }
}

