/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service;

import com.kingdee.bos.framework.cache.service.ICacheSynchronizer;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.rpc.io.loadbalance.IRPCServer;
import com.kingdee.bos.rpc.io.loadbalance.RPCServerView;
import com.kingdee.bos.rpc.io.server.IServer;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCEngineFactory;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class CacheSynchronFactory
implements ICacheSynchronizer {
    public static final Logger logger = Logger.getLogger((String)CacheSynchronFactory.class.getName());
    private List servers = new ArrayList();

    public static ICacheSynchronizer getInstance() {
        CacheSynchronFactory syn = new CacheSynchronFactory();
        RPCServerView sv = RPCServerView.getLast();
        if (sv == null) {
            return syn;
        }
        IRPCServer[] ss = sv.getServers();
        for (int i = 0; i < ss.length; ++i) {
            String url;
            IRPCServer s = ss[i];
            if (s.connectionFailed() || StringUtils.isEmpty((String)(url = s.getUrl())) || CacheSynchronFactory.isLocal(url)) continue;
            try {
                ICacheSynchronizer pcs = (ICacheSynchronizer)RPCEngineFactory.getEngine((String)url).createObject("com.kingdee.bos.framework.cache.service.CacheSynchronizer", ICacheSynchronizer.class);
                syn.servers.add(pcs);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return syn;
    }

    private static boolean isLocal(String url) {
        IServer[] servers = ServerManager.listServers();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].match(url)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dealCache(HashMap msg) {
        int size = this.servers.size();
        for (int i = 0; i < size; ++i) {
            try {
                ((ICacheSynchronizer)this.servers.get(i)).dealCache(msg);
                logger.debug((Object)("cache remove, sended to server[" + this.servers.get(i) + "]."));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return null;
    }
}

