/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service;

import com.kingdee.bos.framework.cache.service.ehcache.EhcacheOuterUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.stefan.snrpc.SnRpcClient;
import org.stefan.snrpc.SnRpcConnectionFactory;
import org.stefan.snrpc.client.CommonSnRpcClient;
import org.stefan.snrpc.client.PoolableRpcConnectionFactory;
import org.stefan.snrpc.client.SnNettyRpcConnectionFactory;

public class RPCClientUtils {
    private static Map<String, SnRpcClient> rpcClientMap = new ConcurrentHashMap<String, SnRpcClient>();
    private static Map<Object, Object> proxyMap = new ConcurrentHashMap<Object, Object>();

    private static SnRpcClient getCommonSnRpcClient(String ip, int port) {
        if (null == rpcClientMap.get(ip + ":" + port)) {
            SnRpcConnectionFactory factory = new SnNettyRpcConnectionFactory(ip, port);
            factory = new PoolableRpcConnectionFactory(factory);
            rpcClientMap.put(ip + ":" + port, new CommonSnRpcClient(factory));
        }
        return rpcClientMap.get(ip + ":" + port);
    }

    public static <T> T getBean(Class<T> clazz) {
        if (!proxyMap.containsKey(clazz)) {
            String[] server = EhcacheOuterUtils.getEhcacheServerListAlive()[0].split(":");
            SnRpcClient client = RPCClientUtils.getCommonSnRpcClient(server[0], Integer.valueOf(server[1]));
            try {
                return client.proxy(clazz, server[0] + ":" + server[1]);
            }
            catch (Throwable e) {
                proxyMap.remove(clazz);
                throw new RuntimeException("get clazz remote proxy error:" + clazz.getName() + "," + e.getMessage());
            }
        }
        return (T)proxyMap.get(clazz);
    }

    public static <T> T getBean(Class<T> clazz, String[] server) {
        SnRpcClient client = RPCClientUtils.getCommonSnRpcClient(server[0], Integer.valueOf(server[1]));
        try {
            return client.proxy(clazz, server[0] + ":" + server[1]);
        }
        catch (Throwable e) {
            throw new RuntimeException("get clazz remote proxy error:" + clazz.getName() + "," + e.getMessage());
        }
    }
}

