/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.command;

import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.framework.cache.service.CacheSyncService;
import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.bos.framework.cache.service.memcache.MemcacheService;
import com.kingdee.bos.framework.ejb.EJBFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public class CacheCommandExecutor {
    private static volatile CacheCommandExecutor instance;
    private static ICacheRouter memcachedSrv;
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, String>> bosTypeCache;
    public static final int DEFUALTBOSTYPESIZE = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheCommandExecutor getInstance() {
        if (instance != null) return instance;
        Class<CacheCommandExecutor> clazz = CacheCommandExecutor.class;
        synchronized (CacheCommandExecutor.class) {
            if (instance != null) return instance;
            instance = new CacheCommandExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CacheCommandExecutor() {
        HashSet<String> remoteCacheConnList = MemcacheService.getInstance().getMemcacheServerLiveList();
        memcachedSrv = remoteCacheConnList == null || remoteCacheConnList.size() == 0 ? null : MemcacheService.getInstance();
        bosTypeCache = new ConcurrentHashMap();
        for (String ais : EJBFactory.getQueryDataSources()) {
            ConcurrentHashMap bostypeMap = new ConcurrentHashMap(2000);
            bosTypeCache.putIfAbsent(ais, bostypeMap);
        }
    }

    public String getOrmKey(String bosType, String ais, String id) {
        Object flag;
        String key = null;
        String bosTypeFlag = this.executeKeyGetInBostypeCache(bosType, ais);
        if (bosTypeFlag == null) {
            bosTypeFlag = Utils.randomStr("BosType");
            this.setBosTypeFlag(ais, bosType, bosTypeFlag);
        }
        if ((flag = this.executeGet(null, bosTypeFlag + id, true)) == null) {
            key = Utils.randomStr("Id");
            this.executePut(null, bosTypeFlag + id, key, 0L);
        } else {
            key = (String)flag;
        }
        return key;
    }

    private void setBosTypeFlag(String ais, String bosType, String bosTypeFlag) {
        this.executeKeyPutInBostypeCache(ais, bosType, bosTypeFlag);
        this.executeReplicateBostypeCache("setBosTypeFlag", new Object[]{ais, bosType, bosTypeFlag});
    }

    private void synchronizerMethod(HashMap<String, Object> msg) {
        CacheSyncService.sendCacheFlushMessage(msg);
    }

    public Object executeGet(String type, String key, boolean clone) {
        return memcachedSrv.getCache(type, key, clone);
    }

    public void executePut(String type, String key, Object value, long objSize) {
        memcachedSrv.putCache(type, key, value, objSize);
    }

    public void executeRemove(String type, String key) {
        memcachedSrv.removeCache(type, key);
    }

    private ConcurrentHashMap<String, String> getBostypeMap(String ais) {
        if (ais == null) {
            return null;
        }
        ConcurrentHashMap<String, String> bosTypeMap = bosTypeCache.get(ais);
        if (bosTypeMap == null) {
            bosTypeMap = new ConcurrentHashMap(2000);
            bosTypeCache.put(ais, bosTypeMap);
        }
        return bosTypeMap;
    }

    public String executeKeyGetInBostypeCache(String bosType, String ais) {
        ConcurrentHashMap<String, String> bosTypeMap = this.getBostypeMap(ais);
        if (bosTypeMap == null) {
            return null;
        }
        return bosTypeMap.get(bosType);
    }

    public void executeKeyRemoveInBostypeCache(String bosType, String ais) {
        ConcurrentHashMap<String, String> bosTypeMap = this.getBostypeMap(ais);
        if (bosTypeMap != null) {
            bosTypeMap.remove(bosType);
        }
    }

    public void executeKeyClearInBostypeCache(String ais) {
        ConcurrentHashMap<String, String> bosTypeMap = this.getBostypeMap(ais);
        if (bosTypeMap != null) {
            bosTypeMap.clear();
        }
    }

    public void executeKeyPutInBostypeCache(String ais, String bosType, String bosTypeFlag) {
        ConcurrentHashMap<String, String> bosTypeMap = this.getBostypeMap(ais);
        if (bosTypeMap != null) {
            bosTypeMap.put(bosType, bosTypeFlag);
        }
    }

    public void executeReplicateBostypeCache(String method, Object[] args) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("method", method);
        msg.put("args", args);
        this.synchronizerMethod(msg);
    }

    public boolean checkMemcachedService() {
        HashSet<String> remoteCacheConnList = MemcacheService.getInstance().getMemcacheServerLiveList();
        if (remoteCacheConnList == null || remoteCacheConnList.size() == 0) {
            memcachedSrv = null;
            return false;
        }
        if (memcachedSrv == null) {
            memcachedSrv = MemcacheService.getInstance();
        }
        return true;
    }
}

