/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.command;

import com.kingdee.bos.framework.cache.service.command.GetOneCacheCommand;
import com.kingdee.bos.framework.cache.service.command.ICacheCommand;
import com.kingdee.bos.framework.cache.service.command.KeyDiscardAllCacheCommand;
import com.kingdee.bos.framework.cache.service.command.KeyDiscardByBostypeCacheCommand;
import com.kingdee.bos.framework.cache.service.command.KeyRemoveBatchCacheCommand;
import com.kingdee.bos.framework.cache.service.command.KeyRemoveCacheCommand;
import com.kingdee.bos.framework.cache.service.command.PutCacheCommand;
import com.kingdee.bos.framework.cache.service.command.RemoveCacheCommand;

public class CacheCommandFactory {
    public static ICacheCommand createGetOneCacheCommand(String type, String key, boolean clone) {
        return new GetOneCacheCommand(type, key, clone);
    }

    public static ICacheCommand createPutCacheCommand(String type, String key, Object value, long objSize) {
        return new PutCacheCommand(type, key, value, objSize);
    }

    public static ICacheCommand createRemoveCacheCommand(String type, String key) {
        return new RemoveCacheCommand(type, key);
    }

    public static ICacheCommand createKeyRemoveCacheCommand(String type, String ais, String pk) {
        return new KeyRemoveCacheCommand(type, ais, pk);
    }

    public static ICacheCommand createKeyRemoveBatchCacheCommand(String type, String ais, String[] pks) {
        return new KeyRemoveBatchCacheCommand(type, ais, pks);
    }

    public static ICacheCommand createKeyDiscardCacheCommand(String ais) {
        return new KeyDiscardAllCacheCommand(ais);
    }

    public static ICacheCommand createKeyDiscardByBostypeCacheCommand(String bostype, String ais) {
        return new KeyDiscardByBostypeCacheCommand(bostype, ais);
    }
}

