/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.ehcache;

import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.bos.framework.cache.service.IOuterCacheAliveChecker;
import com.kingdee.bos.framework.cache.service.RPCClientUtils;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheOuterUtils;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheServiceWraper;
import com.kingdee.bos.rpc.impl.IOUtil;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class EhcacheCacheAliveChecker
implements IOuterCacheAliveChecker {
    private static Logger logger = Logger.getLogger(EhcacheCacheAliveChecker.class);
    private static final EhcacheCacheAliveChecker INSTANCE = new EhcacheCacheAliveChecker();
    private Map<String, ICacheRouter> map = new ConcurrentHashMap<String, ICacheRouter>();
    private final String CACHE_TYPE = "DEFAULT#cache.check";

    private EhcacheCacheAliveChecker() {
    }

    public static IOuterCacheAliveChecker getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkAlive(String server) {
        if (server == null) return false;
        if (!this.checkJDK()) {
            return false;
        }
        boolean isAlive = false;
        Socket so = null;
        try {
            Object obj;
            String[] strs = server.trim().split(":");
            if (strs.length != 2) {
                boolean bl = false;
                if (so == null) return bl;
                IOUtil.close((Object)so);
                return bl;
            }
            so = new Socket();
            so.connect(new InetSocketAddress(strs[0], (int)Integer.valueOf(strs[1])), 3000);
            ICacheRouter customRouter = this.map.get(server);
            if (customRouter == null) {
                customRouter = new EhcacheServiceWraper(RPCClientUtils.getBean(ICacheRouter.class, strs));
                this.map.put(server, customRouter);
                customRouter.putCache("DEFAULT#cache.check", "ping", "ping", 0L);
            }
            if ((obj = customRouter.getCache("DEFAULT#cache.check", "ping", false)) != null) {
                isAlive = true;
            } else {
                customRouter.putCache("DEFAULT#cache.check", "ping", "ping", 0L);
            }
            if (so == null) return isAlive;
        }
        catch (ConnectException e) {
            if (!logger.isDebugEnabled()) return isAlive;
            logger.debug((Object)("Fail to check alive EhcacheCache. and server is " + server), (Throwable)e);
            return isAlive;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception e2) {
                logger.error((Object)("Fail to check alive EhcacheCache. and server is " + server), (Throwable)e2);
                this.map.remove(server);
                if (so == null) return isAlive;
                IOUtil.close((Object)so);
                return isAlive;
            }
        }
        finally {
            if (so != null) {
                IOUtil.close(so);
            }
        }
        IOUtil.close((Object)so);
        return isAlive;
    }

    private boolean checkJDK() {
        return EhcacheOuterUtils.isEhcacheOuter();
    }
}

