/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.ehcache;

import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.service.CacheRouterManager;
import com.kingdee.bos.framework.cache.service.CacheSyncService;
import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.bos.framework.cache.service.ehcache.EhcacheStatus;
import com.kingdee.bos.framework.cache.service.ehcache.MapCacheUtil;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.app.UserMonitorRegistryManager;
import com.kingdee.eas.common.cache.CacheConfigImpl;
import com.kingdee.eas.common.cache.CacheConfigNode;
import com.kingdee.util.ObjectUtils;
import java.lang.reflect.Field;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.core.internal.statistics.DefaultStatisticsService;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.TierStatistics;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.filters.SizeOfFilter;
import org.ehcache.spi.service.Service;

public class EhcacheService
implements ICacheRouter {
    private static final Logger logger = Logger.getLogger(EhcacheService.class);
    private static EhcacheService instance;
    private static Random random;
    private CacheManager manager;
    private StatisticsService statisticsService = new DefaultStatisticsService();
    private static Map<String, AtomicInteger> putCount;
    private static Map<String, EntityStatisInfo> entityStatisMap;
    private static Map<String, EntityStatisInfo> aisStatisMap;
    private int discardAllNumber;
    private int discardRegionNum = 0;
    private int hitNumber = 0;
    private int missNumber = 0;
    private int readNumber = 0;

    public static EhcacheService getInstance() {
        if (instance == null) {
            instance = Init.inst;
        }
        return instance;
    }

    public CacheManager getManager() {
        return this.manager;
    }

    private EhcacheService() {
        this.manager = CacheManagerBuilder.newCacheManagerBuilder().using((Service)this.statisticsService).build(true);
    }

    public synchronized Cache getCacheRegion(String areaName) {
        Cache cache;
        if (areaName == null || "".equals(areaName)) {
            areaName = "defaultCache";
        }
        if ((cache = this.getCacheFromManager(areaName)) == null) {
            Map<String, String> cacheConfig;
            String maxElementsInMemory = "10000";
            String timeToLiveSeconds = "28800" + 60 * random.nextInt(480);
            String timeToIdleSeconds = "28800" + 60 * random.nextInt(480);
            String overflowToDisk = "false";
            String eternal = "false";
            if (CacheConfigManager.getConfig() != null && !CacheConfigManager.getConfig().isCreateByClient() && (cacheConfig = CacheRouterManager.getInstance().getCustomCacheConfig()) != null) {
                String supportDisk;
                String[] strs = areaName.split("#");
                String realName = strs != null && strs.length == 2 ? strs[1] : areaName;
                maxElementsInMemory = cacheConfig.get(realName + ".maxElements");
                if (maxElementsInMemory == null || "".equals(maxElementsInMemory)) {
                    maxElementsInMemory = "10000";
                }
                eternal = (eternal = cacheConfig.get(realName + ".eternal")) != null && "1".equals(eternal) ? "true" : "false";
                timeToLiveSeconds = cacheConfig.get(realName + ".timeToLiveSeconds");
                if (timeToLiveSeconds == null || "".equals(timeToLiveSeconds)) {
                    timeToLiveSeconds = Integer.valueOf(28800 + 60 * random.nextInt(480)).toString();
                }
                if ((timeToIdleSeconds = cacheConfig.get(realName + ".timeToIdleSeconds")) == null || "".equals(timeToIdleSeconds)) {
                    timeToIdleSeconds = Integer.valueOf(28800 + 60 * random.nextInt(480)).toString();
                }
                supportDisk = (supportDisk = cacheConfig.get(realName + ".supportDisk")) != null && "1".equals(supportDisk) ? "true" : "false";
                if (Boolean.valueOf(eternal).booleanValue()) {
                    timeToLiveSeconds = "0";
                    timeToIdleSeconds = "0";
                }
            }
            CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)Long.valueOf(maxElementsInMemory)));
            if ("true".equals(eternal)) {
                builder.withExpiry(Expirations.noExpiration());
            } else {
                builder.withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)Long.valueOf(timeToLiveSeconds), (TimeUnit)TimeUnit.SECONDS))).withExpiry(Expirations.timeToIdleExpiration((Duration)Duration.of((long)Long.valueOf(timeToIdleSeconds), (TimeUnit)TimeUnit.SECONDS)));
            }
            cache = this.manager.createCache(areaName, (Builder)builder);
        }
        return cache;
    }

    @Override
    public void putCache(String type, String key, Object obj, long objSize) {
        Cache cache = this.getCacheRegion(type);
        if (cache != null) {
            String ais;
            String bosType;
            if (putCount.get(type) == null) {
                putCount.put(type, new AtomicInteger(0));
            }
            if ((bosType = EhcacheService.getBosType(type, this.generateKey(type, key))) != null) {
                if (entityStatisMap.get(bosType) == null) {
                    entityStatisMap.put(bosType, new EntityStatisInfo());
                }
                EhcacheService.entityStatisMap.get((Object)bosType).cachePuts.incrementAndGet();
            }
            if ((ais = this.getAis(type)) != null) {
                if (aisStatisMap.get(ais) == null) {
                    aisStatisMap.put(ais, new EntityStatisInfo());
                }
                EhcacheService.aisStatisMap.get((Object)ais).cachePuts.incrementAndGet();
            }
            putCount.get(type).incrementAndGet();
            if (obj == null) {
                cache.remove((Object)this.generateKey(type, key));
            } else {
                cache.put((Object)this.generateKey(type, key), obj);
            }
        }
    }

    private String getAis(String type) {
        return type.split("#")[0];
    }

    @Override
    public Object getCache(String type, String key, boolean clone) {
        String ais;
        Cache cache = this.getCacheRegion(type);
        if (cache == null) {
            return null;
        }
        Object objVal = cache.get((Object)this.generateKey(type, key));
        String bosType = EhcacheService.getBosType(type, this.generateKey(type, key));
        if (bosType != null) {
            if (entityStatisMap.get(bosType) == null) {
                entityStatisMap.put(bosType, new EntityStatisInfo());
            }
            if (objVal == null) {
                EhcacheService.entityStatisMap.get((Object)bosType).cacheMiss.incrementAndGet();
            } else {
                EhcacheService.entityStatisMap.get((Object)bosType).cacheHits.incrementAndGet();
            }
        }
        if ((ais = this.getAis(type)) != null) {
            if (aisStatisMap.get(ais) == null) {
                aisStatisMap.put(ais, new EntityStatisInfo());
            }
            if (objVal == null) {
                EhcacheService.aisStatisMap.get((Object)ais).cacheMiss.incrementAndGet();
            } else {
                EhcacheService.aisStatisMap.get((Object)ais).cacheHits.incrementAndGet();
            }
        }
        if (objVal == null) {
            ++this.missNumber;
            return null;
        }
        ++this.hitNumber;
        try {
            if (objVal != null && clone) {
                objVal = ObjectUtils.createCopy((Object)objVal);
            }
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)e);
        }
        return objVal;
    }

    @Override
    public void removeCache(String type, String key) {
        Cache cache = this.getCacheRegion(type);
        if (cache != null) {
            ++this.discardRegionNum;
            cache.remove((Object)this.generateKey(type, key));
        }
        this.dealCacheSycn("removeCache", type, null, key);
    }

    @Override
    public void removeCacheRegion(String type) {
        this.manager.removeCache(type);
        this.removeCacheRegion(type, "QueryRs");
        this.removeCacheRegion(type, "EntitesObjects");
        this.removeCacheRegion(type, "collections");
        this.dealCacheSycn("removeCacheRegion", type, null, null);
    }

    @Override
    public void removeCacheRegion(String Type2, String cacheType) {
        this.manager.removeCache(Type2 + "#" + cacheType);
        this.dealCacheSycn("removeCacheRegion", Type2 + "#" + cacheType, null, null);
    }

    @Override
    public void removeAllCache() {
        this.removeLocalAllCache();
        this.dealCacheSycn("removeAllCache", null, null, null);
        ++this.discardAllNumber;
    }

    public void removeLocalAllCache() {
        String[] names = this.getCacheNamesFromManager();
        if (names != null) {
            for (String name : names) {
                this.manager.removeCache(name);
            }
        }
    }

    @Override
    public boolean isInCache(String type, String key) {
        ++this.readNumber;
        Cache cache = this.getCacheRegion(type);
        if (cache == null) {
            return false;
        }
        Object obj = cache.get((Object)this.generateKey(type, key));
        return obj != null;
    }

    public String generateKey(String type, String key) {
        return type + "$" + key;
    }

    @Override
    public List getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        String[] names = this.getCacheNamesFromManager();
        for (int i = 0; i < names.length; ++i) {
            Cache<String, Object> cache = this.getCacheFromManager(names[i]);
            if (cache == null) continue;
            for (Cache.Entry entry : cache) {
                String key = (String)entry.getKey();
                keys.add(key);
            }
        }
        return keys;
    }

    public boolean isExistCacheRegion(String areaName) {
        Cache<String, Object> cache = this.getCacheFromManager(areaName);
        return cache != null;
    }

    @Override
    public boolean isInCacheByAix(String aix, String type, String key) {
        return this.isInCache(this.getTypeByAis(aix, type), key);
    }

    @Override
    public void putCacheByAix(String aix, String type, String key, Object obj, long objSize) {
        this.putCache(this.getTypeByAis(aix, type), key, obj, objSize);
    }

    @Override
    public Object getCacheByAix(String aix, String type, String key, boolean clone) {
        return this.getCache(this.getTypeByAis(aix, type), key, clone);
    }

    @Override
    public void removeCacheByAix(String aix, String type, String key) {
        this.removeCache(this.getTypeByAis(aix, type), key);
    }

    @Override
    public void removeCacheRegionByAix(String aix, String type) {
        this.removeCacheRegion(this.getTypeByAis(aix, type));
    }

    @Override
    public void removeCacheRegionByAix(String aix, String type, String cacheType) {
        this.removeCacheRegion(this.getTypeByAis(aix, type), cacheType);
    }

    private String getTypeByAis(String aix, String type) {
        StringBuffer aisName = new StringBuffer("");
        aisName.append(aix).append("#").append(type);
        return aisName.toString();
    }

    private void dealCacheSycn(String method, String areaName, String cacheType, String key) {
        if ("removeAllCache".equals(method) || areaName != null && this.isReplicate(areaName)) {
            HashMap<String, Object> msg = new HashMap<String, Object>();
            msg.put("method", method);
            msg.put("args", new Object[]{areaName, cacheType, key});
            CacheSyncService.sendCacheFlushMessage(msg);
        }
    }

    private boolean isReplicate(String areaName) {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config != null && !config.isCreateByClient()) {
            Map<String, String> cacheConfig = CacheRouterManager.getInstance().getCustomCacheConfig();
            if (cacheConfig != null) {
                String[] strs = areaName.split("#");
                String realName = strs != null && strs.length == 2 ? strs[1] : areaName;
                String isReplicate = cacheConfig.get(realName + ".isReplicate");
                return isReplicate == null || !"0".equals(isReplicate);
            }
            return false;
        }
        return false;
    }

    @Override
    public long getItemCount() {
        long itemCount = 0L;
        itemCount = 0L;
        String[] names = this.getCacheNamesFromManager();
        if (names == null) {
            return itemCount;
        }
        for (int i = 0; i < names.length; ++i) {
            itemCount += (long)this.getCacheSize(names[i]);
        }
        return itemCount;
    }

    @Override
    public long getTotalSize() {
        long totalSize = 0L;
        String[] names = this.getCacheNamesFromManager();
        if (names == null) {
            return totalSize;
        }
        for (int i = 0; i < names.length; ++i) {
            Cache<String, Object> cache = this.getCacheFromManager(names[i]);
            if (cache == null) continue;
            SizeOf sizeOf = SizeOf.newInstance((SizeOfFilter[])new SizeOfFilter[0]);
            long size = sizeOf.deepSizeOf(new Object[]{cache});
            totalSize += size;
        }
        return totalSize;
    }

    @Override
    public long getDiscardAllNum() {
        return this.discardAllNumber;
    }

    @Override
    public long getDiscardRegionNum() {
        return this.discardRegionNum;
    }

    @Override
    public long getHitNum() {
        return this.hitNumber;
    }

    @Override
    public long getMissedNum() {
        return this.missNumber;
    }

    @Override
    public long getReadNum() {
        return this.readNumber;
    }

    public static String getStatis() {
        StringBuffer sb = new StringBuffer();
        sb.append(" MISS CUSTOM ROUTER:").append(CacheRouterManager.missedCustomRouterSet.toString());
        sb.append("\r\n TOTAL :").append("\r\n\thitNumber: " + EhcacheService.getInstance().hitNumber);
        sb.append("\r\n\tmissNumber: " + EhcacheService.getInstance().missNumber).append("\r\n\r\n\r\n");
        Object[] cacheNames = EhcacheService.getInstance().getCacheNamesFromManager();
        Arrays.sort(cacheNames);
        sb.append(EhcacheStatus.getInstance().getStatus());
        for (Object cacheName : cacheNames) {
            boolean isOrmInfo = false;
            boolean isOrmCollection = false;
            if (((String)cacheName).endsWith("orm.info")) {
                isOrmInfo = true;
            } else if (((String)cacheName).endsWith("orm.collection")) {
                isOrmCollection = true;
            }
            sb.append("\r\n\r\n").append((String)cacheName).append("").append(EhcacheStatus.getInstance().getInfomation((String)cacheName));
            sb.append(", putCount:" + putCount.get(cacheName));
            Cache cache = EhcacheService.getInstance().getCacheRegion((String)cacheName);
            int keySize = 0;
            long cucalteSize = 0L;
            HashMap<String, AtomicLong> msize = new HashMap<String, AtomicLong>();
            HashMap<String, AtomicLong> mcount = new HashMap<String, AtomicLong>();
            if (isOrmInfo || isOrmCollection) {
                for (Cache.Entry entry : cache) {
                    String key = (String)entry.getKey();
                    String bosType = EhcacheService.getBosType((String)cacheName, key);
                    if (!msize.containsKey(bosType)) {
                        msize.put(bosType, new AtomicLong(0L));
                        mcount.put(bosType, new AtomicLong(0L));
                    }
                    long sizeO = 0L;
                    ((AtomicLong)msize.get(bosType)).addAndGet(sizeO);
                    ((AtomicLong)mcount.get(bosType)).incrementAndGet();
                    cucalteSize += sizeO;
                    ++keySize;
                }
                sb.append(", cucalteSize:").append(cucalteSize);
                ValueComparator bvc = new ValueComparator(msize);
                TreeMap<String, AtomicLong> sorted_map = new TreeMap<String, AtomicLong>(bvc);
                sorted_map.putAll(msize);
                int i = 0;
                for (String key : sorted_map.keySet()) {
                    if (i++ > 49) break;
                    String entityName = "";
                    try {
                        String filedName = "configMap";
                        Class<CacheConfigImpl> c = CacheConfigImpl.class;
                        try {
                            Field field = c.getDeclaredField(filedName);
                            field.setAccessible(true);
                            Map m = (Map)field.get(c);
                            CacheConfigNode cacheconfig = (CacheConfigNode)m.get(key.substring(((String)cacheName).length() + 1, ((String)cacheName).length() + 9));
                            entityName = cacheconfig.getDescription() + " " + cacheconfig.getName();
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                        }
                        catch (SecurityException securityException) {
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                    catch (Exception filedName) {
                        // empty catch block
                    }
                    sb.append("<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(key).append(": ").append(" counts :").append(mcount.get(key)).append(" ,size :").append(msize.get(key));
                    if (entityStatisMap.containsKey(key)) {
                        EntityStatisInfo esi = entityStatisMap.get(key);
                        sb.append(", hits:").append(esi.cacheHits).append(",miss:").append(esi.cacheMiss).append(",put:").append(esi.cachePuts);
                    }
                    sb.append("  ").append(entityName);
                }
            }
            sb.append(", KeysCount:").append(keySize);
        }
        return sb.toString().replaceAll("\r\n", "<br/>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    private static String getBosType(String cacheName, String key) {
        if (cacheName.endsWith("orm.info") || cacheName.endsWith("orm.collection")) {
            return cacheName + "#" + key.substring(cacheName.length() + 1, cacheName.length() + 9);
        }
        return null;
    }

    @Override
    public long getItemCount(String ais) {
        long itemCount = 0L;
        itemCount = 0L;
        String[] names = this.getCacheNamesFromManager();
        if (names == null) {
            return itemCount;
        }
        for (int i = 0; i < names.length; ++i) {
            if (!this.isAisCache(names[i], ais)) continue;
            itemCount += (long)this.getCacheSize(names[i]);
        }
        return itemCount;
    }

    @Override
    public long getTotalSize(String ais) {
        long totalSize = 0L;
        String[] names = this.getCacheNamesFromManager();
        if (names == null) {
            return totalSize;
        }
        for (int i = 0; i < names.length; ++i) {
            Cache<String, Object> cache;
            if (!this.isAisCache(names[i], ais) || (cache = this.getCacheFromManager(names[i])) == null) continue;
            SizeOf sizeOf = SizeOf.newInstance((SizeOfFilter[])new SizeOfFilter[0]);
            long size = sizeOf.deepSizeOf(new Object[]{cache});
            totalSize += size;
        }
        return totalSize;
    }

    private boolean isAisCache(String cacheName, String ais) {
        if (ais != null && ais.length() > 0 && cacheName != null) {
            return cacheName.startsWith(ais + "#");
        }
        return false;
    }

    @Override
    public List getKeys(String ais) {
        ArrayList<String> keys = new ArrayList<String>();
        String[] names = this.getCacheNamesFromManager();
        for (int i = 0; i < names.length; ++i) {
            Cache<String, Object> cache;
            if (!this.isAisCache(names[i], ais) || (cache = this.getCacheFromManager(names[i])) == null) continue;
            for (Cache.Entry entry : cache) {
                String key = (String)entry.getKey();
                keys.add(key);
            }
        }
        return keys;
    }

    @Override
    public List searchKeys(String preCacheType, String likeStr) {
        ArrayList<String> keys = new ArrayList<String>();
        String[] names = this.getCacheNamesFromManager();
        for (int i = 0; i < names.length; ++i) {
            Cache<String, Object> cache;
            if (preCacheType != null && preCacheType.length() > 0 && !names[i].startsWith(preCacheType) || (cache = this.getCacheFromManager(names[i])) == null) continue;
            for (Cache.Entry entry : cache) {
                String key = (String)entry.getKey();
                if (key.indexOf(likeStr) <= -1) continue;
                keys.add(key);
            }
        }
        return keys;
    }

    @Override
    public long getHitNum(String ais) {
        if (aisStatisMap.containsKey(ais)) {
            return EhcacheService.aisStatisMap.get((Object)ais).cacheHits.get();
        }
        return 0L;
    }

    @Override
    public long getMissedNum(String ais) {
        if (aisStatisMap.containsKey(ais)) {
            return EhcacheService.aisStatisMap.get((Object)ais).cacheMiss.get();
        }
        return 0L;
    }

    @Override
    public long getPutsNum(String ais) {
        if (aisStatisMap.containsKey(ais)) {
            return EhcacheService.aisStatisMap.get((Object)ais).cachePuts.get();
        }
        return 0L;
    }

    @Override
    public void HSET(String ais, String type, String key, String field, Object value) {
        String cacheType = this.getTypeByAis(ais, type);
        key = key + MapCacheUtil.getInstance().getMapFlag(cacheType, key) + field;
        this.putCache(cacheType, key, value, 0L);
    }

    @Override
    public Object HGET(String ais, String type, String key, String field) {
        String cacheType = this.getTypeByAis(ais, type);
        key = key + MapCacheUtil.getInstance().getMapFlag(cacheType, key) + field;
        return this.getCache(cacheType, key, false);
    }

    @Override
    public void HDEL(String ais, String type, String key, String field) {
        String cacheType = this.getTypeByAis(ais, type);
        key = key + MapCacheUtil.getInstance().getMapFlag(cacheType, key) + field;
        this.removeCache(cacheType, key);
    }

    @Override
    public void HDEL(String ais, String type, String key) {
        String cacheType = this.getTypeByAis(ais, type);
        MapCacheUtil.getInstance().removeOneMap(cacheType, key);
        key = key + MapCacheUtil.getInstance().getMapFlag(cacheType, key);
    }

    @Override
    public Map getStatisMapByAis(String ais) {
        HashMap<String, Map<String, Object>> rm = new HashMap<String, Map<String, Object>>();
        String[] names = this.getCacheNamesFromManager();
        int onlineUserCount = this.getOnlineUserCount(ais);
        for (int i = 0; i < names.length; ++i) {
            String cacheName = names[i];
            if (!this.isAisCache(cacheName, ais)) continue;
            Map<String, Object> m = EhcacheStatus.getInstance().getStatusInfoMap(cacheName, false);
            m.put("putCount", putCount.get(cacheName));
            m.put("onlineUserCount", onlineUserCount);
            rm.put(cacheName, m);
        }
        return rm;
    }

    private int getOnlineUserCount(String ais) {
        try {
            HashMap hm = (HashMap)EhcacheService.getObject(UserMonitorRegistryManager.getInstance(), "regInfoMap");
            hm = (HashMap)hm.clone();
            Iterator iter = hm.values().iterator();
            int count = 0;
            while (iter.hasNext()) {
                UMRegistryInfo reg = (UMRegistryInfo)iter.next();
                if (!reg.getDataCenterName().equalsIgnoreCase(ais)) continue;
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public Map getStatisMapByCacheName(String cacheName) {
        Map<String, Object> m = EhcacheStatus.getInstance().getStatusInfoMap(cacheName, true);
        m.put("putCount", putCount.get(cacheName));
        return m;
    }

    private static Object getObject(Object cache, String filedName) {
        Class<?> c = cache.getClass();
        try {
            Field field = c.getDeclaredField(filedName);
            field.setAccessible(true);
            return field.get(cache);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return "";
    }

    public void removeLocal(String type, String key) {
        Cache cache = this.getCacheRegion(type);
        if (cache != null) {
            ++this.discardRegionNum;
            cache.remove((Object)this.generateKey(type, key));
        }
    }

    public Cache<String, Object> getCacheFromManager(String areaName) {
        return this.manager.getCache(areaName, String.class, Object.class);
    }

    public String[] getCacheNamesFromManager() {
        return this.manager.getRuntimeConfiguration().getCacheConfigurations().keySet().toArray(new String[0]);
    }

    public StatisticsService getStatisticsService() {
        return this.statisticsService;
    }

    public int getCacheSize(String areaName) {
        CacheStatistics cs = this.statisticsService.getCacheStatistics(areaName);
        long size = 0L;
        if (cs != null) {
            size = ((TierStatistics)cs.getTierStatistics().get("OnHeap")).getMappings();
        }
        return new Long(size).intValue();
    }

    static {
        random = new SecureRandom();
        putCount = new ConcurrentHashMap<String, AtomicInteger>();
        entityStatisMap = new ConcurrentHashMap<String, EntityStatisInfo>();
        aisStatisMap = new ConcurrentHashMap<String, EntityStatisInfo>();
    }

    static class ValueComparator<String>
    implements Comparator {
        Map<String, AtomicLong> base;

        public ValueComparator(Map<String, AtomicLong> base) {
            this.base = base;
        }

        public int compare(Object a, Object b) {
            if (this.base.get(a).get() >= this.base.get(b).get()) {
                return -1;
            }
            return 1;
        }
    }

    class EntityStatisInfo {
        AtomicLong cacheHits = new AtomicLong(0L);
        AtomicLong cacheMiss = new AtomicLong(0L);
        AtomicLong cachePuts = new AtomicLong(0L);

        EntityStatisInfo() {
        }
    }

    private static class Init {
        private static EhcacheService inst = new EhcacheService();

        private Init() {
        }
    }
}

