/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.ehcache;

import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.bos.mdCache.memcached.client.ContextObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class EhcacheServiceWraper
implements ICacheRouter {
    private static final Logger logger = Logger.getLogger(EhcacheServiceWraper.class);
    private final ICacheRouter router;

    public EhcacheServiceWraper(ICacheRouter router) {
        this.router = router;
    }

    @Override
    public boolean isInCache(String bosType, String key) {
        try {
            return this.router.isInCache(bosType, key);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void putCache(String type, String key, Object obj, long objSize) {
        try {
            this.router.putCache(type, key, this.objectToByte(obj), objSize);
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public Object getCache(String type, String key, boolean clone) {
        try {
            return this.byteToObject((byte[])this.router.getCache(type, key, clone));
        }
        catch (Exception e) {
            logger.equals("outer ehcache  is error ,inner ehcache is running");
            return null;
        }
    }

    @Override
    public void removeCache(String type, String key) {
        try {
            this.router.removeCache(type, key);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeCacheRegion(String Type2) {
        try {
            this.router.removeCacheRegion(Type2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeCacheRegion(String Type2, String cacheType) {
        try {
            this.router.removeCacheRegion(Type2, cacheType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeAllCache() {
        this.router.removeAllCache();
    }

    @Override
    public boolean isInCacheByAix(String aix, String bosType, String key) {
        try {
            return this.router.isInCacheByAix(aix, bosType, key);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void putCacheByAix(String aix, String type, String key, Object obj, long objSize) {
        try {
            this.router.putCacheByAix(aix, type, key, this.objectToByte(obj), objSize);
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public Object getCacheByAix(String aix, String type, String key, boolean clone) {
        try {
            return this.byteToObject((byte[])this.router.getCacheByAix(aix, type, key, clone));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void removeCacheByAix(String aix, String type, String key) {
        try {
            this.router.removeCacheByAix(aix, type, key);
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public void removeCacheRegionByAix(String aix, String Type2) {
        try {
            this.router.removeCacheRegionByAix(aix, Type2);
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public void removeCacheRegionByAix(String aix, String Type2, String cacheType) {
        try {
            this.router.removeCacheRegionByAix(aix, Type2, cacheType);
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public long getItemCount() {
        return this.router.getItemCount();
    }

    @Override
    public long getTotalSize() {
        return this.router.getTotalSize();
    }

    @Override
    public long getReadNum() {
        return this.router.getReadNum();
    }

    @Override
    public long getHitNum() {
        return this.router.getHitNum();
    }

    @Override
    public long getDiscardAllNum() {
        return this.router.getDiscardAllNum();
    }

    @Override
    public long getDiscardRegionNum() {
        return this.router.getDiscardRegionNum();
    }

    @Override
    public List getKeys() {
        return this.router.getKeys();
    }

    private byte[] objectToByte(Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(bos).writeObject(o);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        byte[] val = bos.toByteArray();
        return val;
    }

    private Object byteToObject(byte[] b) {
        if (b == null) {
            return null;
        }
        Object o = null;
        ContextObjectInputStream ois = null;
        try {
            ois = new ContextObjectInputStream((InputStream)new ByteArrayInputStream(b), null);
            o = ois.readObject();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        return o;
    }

    @Override
    public long getItemCount(String ais) {
        return this.router.getItemCount(ais);
    }

    @Override
    public long getTotalSize(String ais) {
        return this.router.getTotalSize(ais);
    }

    @Override
    public long getHitNum(String ais) {
        return this.router.getHitNum(ais);
    }

    @Override
    public List getKeys(String ais) {
        return this.router.getKeys(ais);
    }

    @Override
    public long getMissedNum() {
        return this.router.getMissedNum();
    }

    @Override
    public long getMissedNum(String ais) {
        return this.router.getMissedNum(ais);
    }

    @Override
    public long getPutsNum(String ais) {
        return this.router.getPutsNum(ais);
    }

    @Override
    public void HSET(String ais, String type, String key, String field, Object value) {
        this.router.HSET(ais, type, key, field, this.objectToByte(value));
    }

    @Override
    public Object HGET(String ais, String type, String key, String field) {
        return this.byteToObject((byte[])this.router.HGET(ais, type, key, field));
    }

    @Override
    public void HDEL(String ais, String type, String key, String field) {
        this.router.HDEL(ais, type, key, field);
    }

    public boolean HEXISTS(String ais, String type, String key, String field) {
        return false;
    }

    public Set<String> HKEYS(String ais, String type, String key) {
        return null;
    }

    @Override
    public Map getStatisMapByAis(String ais) {
        return this.router.getStatisMapByAis(ais);
    }

    @Override
    public Map getStatisMapByCacheName(String cacheName) {
        return this.router.getStatisMapByCacheName(cacheName);
    }

    @Override
    public void HDEL(String ais, String type, String key) {
        this.router.HDEL(ais, type, key);
    }

    @Override
    public List searchKeys(String ais, String likeStr) {
        return this.router.searchKeys(ais, likeStr);
    }
}

