/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.ehcache;

import com.kingdee.bos.framework.cache.service.ehcache.EhcacheService;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.filters.SizeOfFilter;

public class EhcacheStatus {
    private static final Logger logger = Logger.getLogger(EhcacheStatus.class);
    private static EhcacheStatus instance;
    private MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    public static EhcacheStatus getInstance() {
        if (instance == null) {
            instance = Init.inst;
        }
        return instance;
    }

    private CacheManager getEhcacheCacheManager() {
        return EhcacheService.getInstance().getManager();
    }

    private ObjectName getObjectName(String cacheName) {
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("net.sf.ehcache:type=CacheStatistics,CacheManager=__DEFAULT__,name=" + cacheName);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
        return objectName;
    }

    public String getStatus() {
        return this.getEhcacheCacheManager().getStatus().toString();
    }

    private Double getMBeanAttributeD(String cacheName, String attributeName) {
        Object obj = null;
        try {
            obj = this.mBeanServer.getAttribute(this.getObjectName(cacheName), attributeName);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
        if (obj == null) {
            return 0.0;
        }
        return Double.parseDouble(obj.toString());
    }

    private Long getMBeanAttributeL(String cacheName, String attributeName) {
        Object obj = null;
        try {
            obj = this.mBeanServer.getAttribute(this.getObjectName(cacheName), attributeName);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
        if (obj == null) {
            return 0L;
        }
        return Long.parseLong(obj.toString());
    }

    public double getCacheHitRatio(String cacheName) {
        return this.getMBeanAttributeD(cacheName, "CacheHitPercentage");
    }

    public long getCacheHits(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "CacheHits");
    }

    public long getCacheMisses(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "CacheMisses");
    }

    public double getCacheHitRatioInMemory(String cacheName) {
        return this.getMBeanAttributeD(cacheName, "InMemoryHitPercentage");
    }

    public long getCacheHitsInMemory(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "InMemoryHits");
    }

    public long getInMemoryMissesInMemory(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "InMemoryMisses");
    }

    public double getCacheHitRatioInDisk(String cacheName) {
        return this.getMBeanAttributeD(cacheName, "OnDiskHitPercentage");
    }

    public long getOnDiskHitsInDisk(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "OnDiskHits");
    }

    public long getOnDiskMissesInDisk(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "OnDiskMisses");
    }

    public long getCacheCount(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "ObjectCount");
    }

    public long getCacheCountInMemory(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "MemoryStoreObjectCount");
    }

    public long getCacheCountInDisk(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "DiskStoreObjectCount");
    }

    public long getWriterMaxQueueSize(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "WriterMaxQueueSize");
    }

    public long getWriterQueueLength(String cacheName) {
        return this.getMBeanAttributeL(cacheName, "WriterQueueLength");
    }

    public long getCacheSize(String cacheName) {
        Cache cache = this.getEhcacheCacheManager().getCache(cacheName, String.class, Object.class);
        if (cache == null) {
            return 0L;
        }
        SizeOf sizeOf = SizeOf.newInstance((SizeOfFilter[])new SizeOfFilter[0]);
        long size = sizeOf.deepSizeOf(new Object[]{cache});
        return size;
    }

    public String getInfomation(String cacheName) {
        StringBuffer sb = new StringBuffer();
        sb.append("\r\n\tCacheHits:").append(this.getCacheHits(cacheName));
        sb.append(", CacheMisses:").append(this.getCacheMisses(cacheName));
        sb.append(", CacheHitRatio:").append(this.getCacheHitRatio(cacheName));
        sb.append("\r\n\tInMemoryHits:").append(this.getCacheHitsInMemory(cacheName));
        sb.append(", InMemoryMisses:").append(this.getInMemoryMissesInMemory(cacheName));
        sb.append(", InMemoryHitRatio:").append(this.getCacheHitRatioInMemory(cacheName));
        sb.append("\r\n\tOnDiskHits:").append(this.getOnDiskHitsInDisk(cacheName));
        sb.append(", OnDiskMisses:").append(this.getOnDiskMissesInDisk(cacheName));
        sb.append(", OnDiskHitRatio:").append(this.getCacheHitRatioInDisk(cacheName));
        sb.append("\r\n\tMemoryStoreObjectCount:").append(this.getCacheCountInMemory(cacheName));
        sb.append(", DiskStoreObjectCount:").append(this.getCacheCountInDisk(cacheName));
        sb.append(", WriterMaxQueueSize:").append(this.getWriterMaxQueueSize(cacheName));
        sb.append(", WriterQueueLength:").append(this.getWriterQueueLength(cacheName));
        sb.append("\r\n\tCacheSize:").append(this.getCacheSize(cacheName));
        return sb.toString();
    }

    public Map<String, Object> getStatusInfoMap(String cacheName, boolean needGetSize) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("CacheHits", this.getCacheHits(cacheName));
        m.put("CacheMisses", this.getCacheMisses(cacheName));
        m.put("CacheHitRatio", this.getCacheHitRatio(cacheName));
        m.put("InMemoryHits", this.getCacheHitsInMemory(cacheName));
        m.put("InMemoryMisses", this.getInMemoryMissesInMemory(cacheName));
        m.put("InMemoryHitRatio", this.getCacheHitRatioInMemory(cacheName));
        m.put("OnDiskHits", this.getOnDiskHitsInDisk(cacheName));
        m.put("OnDiskMisses", this.getOnDiskMissesInDisk(cacheName));
        m.put("OnDiskHitRatio", this.getCacheHitRatioInDisk(cacheName));
        m.put("MemoryStoreObjectCount", this.getCacheCountInMemory(cacheName));
        m.put("DiskStoreObjectCount", this.getCacheCountInDisk(cacheName));
        if (needGetSize) {
            m.put("CacheSize", this.getCacheSize(cacheName));
        }
        return m;
    }

    private static class Init {
        private static EhcacheStatus inst = new EhcacheStatus();

        private Init() {
        }
    }
}

