/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.ehcache;

import com.kingdee.bos.framework.cache.service.CacheSyncService;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class MapCacheUtil {
    private static MapCacheUtil mapCacheUtil;
    private static ConcurrentHashMap<String, String> mapFlagCache;

    public static MapCacheUtil getInstance() {
        if (mapCacheUtil == null) {
            mapCacheUtil = new MapCacheUtil();
        }
        return mapCacheUtil;
    }

    public String getMapFlag(String cacheType, String key) {
        String obj = mapFlagCache.get(cacheType + key);
        if (obj == null) {
            SecureRandom random = new SecureRandom();
            String flag = "_" + random.nextInt(1000) + "M_";
            mapFlagCache.put(cacheType + key, flag);
            return flag;
        }
        return obj.toString();
    }

    public void updateMapFlag(String cacheType, String key, String flag, boolean notifyServer) {
        mapFlagCache.put(cacheType + key, flag);
        if (notifyServer) {
            HashMap<String, Object> msg = new HashMap<String, Object>();
            msg.put("method", "Map_Update_MapID_Flag");
            msg.put("args", new Object[]{cacheType, key, flag, false});
            CacheSyncService.sendCacheFlushMessage(msg);
        }
    }

    public void removeOneMap(String cacheType, String key) {
        SecureRandom random = new SecureRandom();
        String flag = "_" + random.nextInt(1000) + "M_";
        this.updateMapFlag(cacheType, key, flag, true);
    }

    static {
        mapFlagCache = new ConcurrentHashMap();
    }
}

