/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.ehcacherestful;

import com.kingdee.bos.framework.cache.service.CacheRouter;
import com.kingdee.bos.framework.cache.service.ehcacherestful.EhcacheRestfulManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class EhCacheRestfulService
implements CacheRouter {
    private List serverUrl = EhcacheRestfulManager.getInstance().getEhcacheServerUrl();
    private static final Logger logger = Logger.getLogger(EhCacheRestfulService.class);
    private static volatile EhCacheRestfulService instance;
    int discardAllNum = 0;
    int discardRegionNum = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EhCacheRestfulService getInstance() {
        if (instance != null) return instance;
        Class<EhCacheRestfulService> clazz = EhCacheRestfulService.class;
        synchronized (EhCacheRestfulService.class) {
            if (instance != null) return instance;
            instance = new EhCacheRestfulService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAllCache(String urlStr) throws Exception {
        URL u = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)u.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        StringBuffer out = new StringBuffer();
        InputStream is = null;
        try {
            int n;
            is = connection.getInputStream();
            byte[] response1 = new byte[4096];
            while ((n = is.read(response1)) != -1) {
                out.append(new String(response1, 0, n));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        connection.disconnect();
        return out.toString();
    }

    public boolean isCache(String type) throws Exception {
        URL u = new URL(this.getCacheUrl(this.serverUrl, type));
        HttpURLConnection connection = (HttpURLConnection)u.openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        int status = connection.getResponseCode();
        return status != 404;
    }

    public void createCache(String type) throws Exception {
        URL u = new URL(this.getCacheUrl(this.serverUrl, type));
        HttpURLConnection urlConnection = (HttpURLConnection)u.openConnection();
        urlConnection.setRequestMethod("PUT");
        urlConnection.disconnect();
    }

    @Override
    public boolean isInCache(String type, String key) {
        try {
            URL url = new URL(this.getObjUrl(this.serverUrl, type, key));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/x-java-serialized-object");
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.connect();
            int status = connection.getResponseCode();
            if (status == 404) {
                return false;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putCache(String type, String key, Object obj, long size) {
        OutputStream os = null;
        try {
            if (!this.isCache(type)) {
                this.createCache(type);
            }
            URL url = new URL(this.getObjUrl(this.serverUrl, type, key));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/x-java-serialized-object");
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.connect();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            byte[] bs = baos.toByteArray();
            os = connection.getOutputStream();
            os.write(bs, 0, bs.length);
            os.flush();
            connection.getResponseCode();
            connection.disconnect();
        }
        catch (Exception ex) {
            logger.warn((Object)("put cache error:" + ex));
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCache(String type, String key) {
        Object obj = null;
        InputStream is = null;
        try {
            URL url = new URL(this.getObjUrl(this.serverUrl, type, key));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("Content-Type", "application/x-java-serialized-object");
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            connection.connect();
            int status = connection.getResponseCode();
            if (status == 404) {
                Object var8_11 = null;
                return var8_11;
            }
            is = connection.getInputStream();
            byte[] response = new byte[4096];
            int result = is.read(response);
            while (result != -1) {
                result = is.read(response);
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            connection.disconnect();
            ByteArrayInputStream byteIn = new ByteArrayInputStream(response);
            ObjectInputStream objIn = new ObjectInputStream(byteIn);
            obj = objIn.readObject();
            objIn.close();
        }
        catch (Exception ex) {
            logger.warn((Object)("get cache error:" + ex));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return obj;
    }

    @Override
    public void removeCache(String type, String key) {
        try {
            URL url = new URL(this.getObjUrl(this.serverUrl, type, key));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.connect();
            if (connection != null) {
                connection.disconnect();
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("remove cache error:" + ex));
        }
        ++this.discardRegionNum;
    }

    @Override
    public void removeCacheRegion(String type) {
        try {
            Calendar c = Calendar.getInstance();
            URL url = new URL(this.getRemoveAllCacheUrl(this.serverUrl, type));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("DELETE");
            connection.connect();
            connection.disconnect();
            ++this.discardRegionNum;
            Calendar c2 = Calendar.getInstance();
            logger.info((Object)(type + "------remove all type  = " + (c2.getTimeInMillis() - c.getTimeInMillis())));
        }
        catch (Exception ex) {
            logger.warn((Object)("remove CacheRegion error:" + ex));
        }
    }

    public void deleteCacheRegion(String type) {
        try {
            URL url = new URL(this.getCacheUrl(this.serverUrl, type));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (connection != null) {
                connection.setRequestMethod("DELETE");
                connection.connect();
                connection.disconnect();
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("delete CacheRegion error:" + ex));
        }
        ++this.discardRegionNum;
    }

    private String getCacheUrl(List servers, String type) {
        return this.additiveHash(servers, type) + "/" + type;
    }

    private String getRemoveAllCacheUrl(List servers, String type) {
        return this.additiveHash(servers, type) + "/" + type + "/*";
    }

    private String getObjUrl(List servers, String type, String key) {
        return this.additiveHash(servers, type) + "/" + type + "/" + key;
    }

    private String additiveHash(List servers, String key) {
        int hash = key.length();
        for (int i = 0; i < key.length(); ++i) {
            hash += key.charAt(i);
        }
        int hashNum = hash % servers.size();
        return String.valueOf(servers.get(hashNum));
    }

    private Element getRoot(String url) {
        Element root = null;
        try {
            String statStr = this.getAllCache(url);
            SAXReader reader = new SAXReader();
            Document doc = reader.read((InputStream)new ByteArrayInputStream(statStr.getBytes()));
            root = doc.getRootElement();
        }
        catch (Exception ex) {
            logger.warn((Object)("getRoot from url error:" + ex));
        }
        return root;
    }

    @Override
    public long getItemCount() {
        long itemCount = 0L;
        for (int k = 0; k < this.serverUrl.size(); ++k) {
            String url = String.valueOf(this.serverUrl.get(k));
            try {
                Element root = this.getRoot(url);
                Iterator i = root.elementIterator("cache");
                while (i.hasNext()) {
                    Element foo = (Element)i.next();
                    Element statEl = foo.element("statistics");
                    String itemNumStr = statEl.elementText("size");
                    if (itemNumStr == null || itemNumStr.equals("")) continue;
                    itemCount += Long.parseLong(itemNumStr);
                }
                continue;
            }
            catch (Exception ex) {
                logger.warn((Object)("getItemCount error:" + ex));
            }
        }
        return itemCount;
    }

    @Override
    public long getTotalSize() {
        return 0L;
    }

    @Override
    public long getReadNum() {
        long readNum = 0L;
        for (int k = 0; k < this.serverUrl.size(); ++k) {
            String url = String.valueOf(this.serverUrl.get(k));
            try {
                Element root = this.getRoot(url);
                Iterator i = root.elementIterator("cache");
                while (i.hasNext()) {
                    String missStr;
                    Element foo = (Element)i.next();
                    Element statEl = foo.element("statistics");
                    String hitStr = statEl.elementText("cacheHits");
                    if (hitStr != null && !hitStr.equals("")) {
                        readNum += (long)Integer.parseInt(hitStr);
                    }
                    if ((missStr = statEl.elementText("misses")) == null || missStr.equals("")) continue;
                    readNum += (long)Integer.parseInt(missStr);
                }
                continue;
            }
            catch (Exception ex) {
                logger.warn((Object)("getReadNum error:" + ex));
            }
        }
        return readNum;
    }

    @Override
    public long getHitNum() {
        long hitNum = 0L;
        for (int k = 0; k < this.serverUrl.size(); ++k) {
            String url = String.valueOf(this.serverUrl.get(k));
            try {
                Element root = this.getRoot(url);
                Iterator i = root.elementIterator("cache");
                while (i.hasNext()) {
                    Element foo = (Element)i.next();
                    Element statEl = foo.element("statistics");
                    String hitStr = statEl.elementText("cacheHits");
                    if (hitStr == null || hitStr.equals("")) continue;
                    hitNum += (long)Integer.parseInt(hitStr);
                }
                continue;
            }
            catch (Exception ex) {
                logger.warn((Object)("getHitNum error:" + ex));
            }
        }
        return hitNum;
    }

    @Override
    public long getDiscardAllNum() {
        return this.discardAllNum;
    }

    @Override
    public long getDiscardRegionNum() {
        return this.discardRegionNum;
    }

    @Override
    public void removeAllCache() {
    }
}

