/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.memcache;

import com.kingdee.bos.framework.cache.service.memcache.MemcacheUtil;
import com.kingdee.bos.mdCache.memcached.client.MemCachedClient;
import com.kingdee.bos.mdCache.memcached.client.SockIOPool;
import com.kingdee.bos.util.backport.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemcacheManager {
    private static volatile MemcacheManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MemcacheManager getInstance() {
        if (instance != null) return instance;
        Class<MemcacheManager> clazz = MemcacheManager.class;
        synchronized (MemcacheManager.class) {
            if (instance != null) return instance;
            instance = new MemcacheManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MemcacheManager() {
        this.initCachePool();
    }

    public void initCachePool() {
        String[] memServerList = MemcacheUtil.getInstance().getMemcacheServerList();
        if (memServerList == null || memServerList.length == 0) {
            return;
        }
        SockIOPool.removeInstance((String)"eas");
        SockIOPool pool = null;
        pool = SockIOPool.getInstance((String)"eas");
        pool.setServers(memServerList);
        pool.setHashingAlg(MemcacheUtil.getInstance().getHashAlg());
        pool.setInitConn(50);
        pool.setMinConn(50);
        pool.setMaxConn(200);
        pool.setNagle(false);
        pool.initialize();
    }

    public MemCachedClient getMemClient() {
        return new MemCachedClient("eas");
    }

    private List getStatsMap() {
        String[] memServerList = MemcacheUtil.getInstance().getMemcacheServerList();
        MemCachedClient mc = this.getMemClient();
        ArrayList<Map> list = new ArrayList<Map>();
        Map statsMap = mc.stats(memServerList);
        if (statsMap == null) {
            return null;
        }
        Collection c = statsMap.values();
        if (c == null || c.size() <= 0) {
            return null;
        }
        Object[] objArr = c.toArray();
        for (int i = 0; i < objArr.length; ++i) {
            Map singStatMap = (Map)objArr[i];
            list.add(singStatMap);
        }
        return list;
    }

    public long getBytes() {
        long bytes = 0L;
        List list = this.getStatsMap();
        if (list == null || list.size() == 0) {
            return bytes;
        }
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String tempStr = String.valueOf(map.get("bytes"));
            if ("null".equals(tempStr)) continue;
            bytes += Long.parseLong(tempStr);
        }
        return bytes;
    }

    public long getReads() {
        long readNum = 0L;
        List list = this.getStatsMap();
        if (list == null || list.size() == 0) {
            return readNum;
        }
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String tempStr = String.valueOf(map.get("cmd_get"));
            if ("null".equals(tempStr)) continue;
            readNum += Long.parseLong(tempStr);
        }
        return readNum;
    }

    public long getPuts() {
        long setNum = 0L;
        List list = this.getStatsMap();
        if (list == null || list.size() == 0) {
            return setNum;
        }
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String tempStr = String.valueOf(map.get("cmd_set"));
            if ("null".equals(tempStr)) continue;
            setNum += Long.parseLong(tempStr);
        }
        return setNum;
    }

    public long getHits() {
        long readNum = 0L;
        List list = this.getStatsMap();
        if (list == null || list.size() == 0) {
            return readNum;
        }
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String tempStr = String.valueOf(map.get("get_hits"));
            if ("null".equals(tempStr)) continue;
            readNum += Long.parseLong(tempStr);
        }
        return readNum;
    }

    public long getDeletes() {
        long readNum = 0L;
        List list = this.getStatsMap();
        if (list == null || list.size() == 0) {
            return readNum;
        }
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String tempStr = String.valueOf(map.get("delete_hits"));
            if ("null".equals(tempStr)) continue;
            readNum += Long.parseLong(tempStr);
        }
        return readNum;
    }

    public long getItems() {
        long items = 0L;
        List list = this.getStatsMap();
        if (list == null || list.size() == 0) {
            return items;
        }
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String tempStr = String.valueOf(map.get("curr_items"));
            if ("null".equals(tempStr)) continue;
            items += Long.parseLong(tempStr);
        }
        return items;
    }

    public List getKeys() {
        MemCachedClient mc = this.getMemClient();
        Set set = mc.getKeySet(true);
        List list = Arrays.asList((Object[])set.toArray());
        return list;
    }

    public static void main(String[] args) {
        SockIOPool pool = SockIOPool.getInstance((String)"test");
        pool.setServers(new String[]{"127.0.0.1:11311"});
        pool.setInitConn(0);
        pool.setMinConn(0);
        pool.setMaxConn(200);
        pool.setNagle(true);
        pool.initialize();
        MemCachedClient mc = new MemCachedClient("test");
        for (int i = 0; i < 100; ++i) {
            mc.add("1" + i, (Object)i);
        }
    }
}

