/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.memcache;

import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import com.kingdee.bos.framework.cache.service.ICacheRouter;
import com.kingdee.bos.framework.cache.service.memcache.MemcacheManager;
import com.kingdee.bos.framework.cache.service.memcache.MemcachedFlagService;
import com.kingdee.bos.mdCache.memcached.client.MemCachedClient;
import com.kingdee.bos.mdCache.memcached.client.SockIOPool;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class MemcacheService
implements ICacheRouter {
    private static Logger log = Logger.getLogger((String)MemcacheService.class.getName());
    private static volatile MemcacheService instance;
    private LinkedBlockingQueue<Element> memcachedAsycCommandQueue = new LinkedBlockingQueue();
    private MemcachedFlagService keyCacheSrv;
    private MemCachedClient memClient = MemcacheManager.getInstance().getMemClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MemcacheService getInstance() {
        if (instance != null) return instance;
        Class<MemcacheService> clazz = MemcacheService.class;
        synchronized (MemcacheService.class) {
            if (instance != null) return instance;
            instance = new MemcacheService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void reInitService() {
        instance = null;
    }

    private MemcacheService() {
        this.keyCacheSrv = MemcachedFlagService.getInstance();
        MemcachedAsycOperate memcachedAsycOperateThread = new MemcachedAsycOperate();
        memcachedAsycOperateThread.start();
    }

    public HashSet<String> getMemcacheServerLiveList() {
        return SockIOPool.getInstance((String)"eas").getServerLiveSet();
    }

    @Override
    public boolean isInCache(String type, String key) {
        return this.memClient.keyExists(this.generateKey(type, key));
    }

    @Override
    public void putCache(String type, String key, Object obj, long objSize) {
        Element element = new Element(this.generateKey(type, key), obj);
        try {
            this.memcachedAsycCommandQueue.put(element);
        }
        catch (InterruptedException e) {
            log.warn((Object)("#Memcache# Interrupted on put data" + e.getMessage()));
        }
    }

    @Override
    public Object getCache(String type, String key, boolean clone) {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config.isIgnoreException()) {
            try {
                return this.memClient.get(this.generateKey(type, key));
            }
            catch (Exception e) {
                log.error((Object)"#Memcache# get data error ", (Throwable)e);
                return null;
            }
        }
        return this.memClient.get(this.generateKey(type, key));
    }

    @Override
    public void removeCache(String type, String key) {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config.isIgnoreException()) {
            try {
                this.memClient.delete(this.generateKey(type, key));
            }
            catch (Exception e) {
                log.error((Object)"#Memcache# remove data error ", (Throwable)e);
            }
        } else {
            this.memClient.delete(this.generateKey(type, key));
        }
    }

    @Override
    public void removeCacheRegion(String type) {
        this.keyCacheSrv.delType(ConfigMDUtil.getAIS(), type);
    }

    @Override
    public void removeAllCache() {
        this.memClient.flushAll();
    }

    @Override
    public long getItemCount() {
        return MemcacheManager.getInstance().getItems();
    }

    @Override
    public long getTotalSize() {
        return MemcacheManager.getInstance().getBytes();
    }

    @Override
    public long getReadNum() {
        return MemcacheManager.getInstance().getReads();
    }

    @Override
    public long getHitNum() {
        return MemcacheManager.getInstance().getHits();
    }

    @Override
    public long getDiscardAllNum() {
        return 0L;
    }

    @Override
    public long getDiscardRegionNum() {
        return MemcacheManager.getInstance().getDeletes();
    }

    private String getBotypeFlag(String aix, String type) {
        ConcurrentHashMap aixs = this.keyCacheSrv.getCache().get(aix);
        if (aixs == null) {
            ConcurrentHashMap bostypeMap = new ConcurrentHashMap(2000);
            this.keyCacheSrv.getCache().putIfAbsent(aix, bostypeMap);
            aixs = this.keyCacheSrv.getCache().get(aix);
        }
        return (String)aixs.get(type);
    }

    private String generateKey(String type, String key) {
        key = Utils.transMD5(key);
        if (type == null) {
            return key;
        }
        String aix = ConfigMDUtil.getAIS();
        if (this.keyCacheSrv != null) {
            String flag = this.getBotypeFlag(aix, type);
            if (flag == null) {
                flag = this.RandomStr(type);
                this.keyCacheSrv.setTypeFlag(aix, type, flag);
            }
            return flag + "#" + key;
        }
        return key;
    }

    private String generateKey(String aix, String type, String key) {
        if (aix == null) {
            return this.generateKey(type, key);
        }
        if (type == null) {
            return key;
        }
        if (this.keyCacheSrv != null) {
            String flag = this.getBotypeFlag(aix, type);
            if (flag == null) {
                flag = this.RandomStr(type);
                this.keyCacheSrv.setTypeFlag(aix, type, flag);
            }
            return flag + "#" + key;
        }
        return key;
    }

    private String RandomStr(String type) {
        String ret = "";
        SecureRandom rd = new SecureRandom();
        ret = type + "#" + String.valueOf(rd.nextInt());
        return ret;
    }

    @Override
    public List getKeys() {
        return MemcacheManager.getInstance().getKeys();
    }

    @Override
    public void removeCacheRegion(String Type2, String cacheType) {
        this.removeCacheRegion(Type2 + "#" + cacheType);
    }

    @Override
    public boolean isInCacheByAix(String aix, String bosType, String key) {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config.isIgnoreException()) {
            try {
                return this.memClient.keyExists(this.generateKey(aix, bosType, key));
            }
            catch (Exception e) {
                log.error((Object)"#Memcache# check data for aix error ", (Throwable)e);
                return false;
            }
        }
        return this.memClient.keyExists(this.generateKey(aix, bosType, key));
    }

    @Override
    public void putCacheByAix(String aix, String type, String key, Object obj, long objSize) {
        Element element = new Element(this.generateKey(aix, type, key), obj);
        try {
            this.memcachedAsycCommandQueue.put(element);
        }
        catch (InterruptedException e) {
            log.warn((Object)("#Memcache# Interrupted on put data for aix" + e.getMessage()));
        }
    }

    @Override
    public Object getCacheByAix(String aix, String type, String key, boolean clone) {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config.isIgnoreException()) {
            try {
                return this.memClient.get(this.generateKey(aix, type, key));
            }
            catch (Exception e) {
                log.error((Object)"#Memcache# get data for aix error ", (Throwable)e);
                return null;
            }
        }
        return this.memClient.get(this.generateKey(aix, type, key));
    }

    @Override
    public void removeCacheByAix(String aix, String type, String key) {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config.isIgnoreException()) {
            try {
                this.memClient.delete(this.generateKey(aix, type, key));
            }
            catch (Exception e) {
                log.error((Object)"#Memcache# delete data for aix error ", (Throwable)e);
            }
        } else {
            this.memClient.delete(this.generateKey(aix, type, key));
        }
    }

    @Override
    public void removeCacheRegionByAix(String aix, String type) {
        this.keyCacheSrv.delType(aix, type);
    }

    @Override
    public void removeCacheRegionByAix(String aix, String Type2, String cacheType) {
        this.removeCacheRegionByAix(aix, Type2 + "#" + cacheType);
    }

    private void handleMemcachedAsycOperate() {
        while (true) {
            Element element;
            ICacheConfig config;
            if ((config = CacheConfigManager.getConfig()).isIgnoreException()) {
                try {
                    element = this.memcachedAsycCommandQueue.take();
                    if (element == null) continue;
                    this.memClient.set(element.getKey().toString(), element.getValue());
                }
                catch (InterruptedException e) {
                    log.warn((Object)("#Memcache# Interrupted on take data" + e.getMessage()));
                }
                catch (Exception e) {
                    log.error((Object)"#Memcache# put data error ", (Throwable)e);
                }
                continue;
            }
            try {
                element = this.memcachedAsycCommandQueue.take();
                if (element == null) continue;
                this.memClient.set(element.getKey().toString(), element.getValue());
                continue;
            }
            catch (InterruptedException e) {
                log.warn((Object)("#Memcache# Interrupted on take data" + e.getMessage()));
                continue;
            }
            break;
        }
    }

    @Override
    public long getItemCount(String ais) {
        return 0L;
    }

    @Override
    public long getTotalSize(String ais) {
        return 0L;
    }

    @Override
    public List getKeys(String ais) {
        return null;
    }

    @Override
    public long getMissedNum() {
        return 0L;
    }

    @Override
    public long getMissedNum(String ais) {
        return 0L;
    }

    @Override
    public long getHitNum(String ais) {
        return 0L;
    }

    @Override
    public long getPutsNum(String ais) {
        return 0L;
    }

    @Override
    public void HSET(String ais, String type, String key, String field, Object value) {
    }

    @Override
    public Object HGET(String ais, String type, String key, String field) {
        return null;
    }

    @Override
    public void HDEL(String ais, String type, String key, String field) {
    }

    public boolean HEXISTS(String ais, String type, String key, String field) {
        return false;
    }

    public Set<String> HKEYS(String ais, String type, String key) {
        return null;
    }

    @Override
    public Map getStatisMapByAis(String ais) {
        return null;
    }

    @Override
    public Map getStatisMapByCacheName(String cacheName) {
        return null;
    }

    @Override
    public void HDEL(String ais, String type, String key) {
    }

    @Override
    public List searchKeys(String ais, String likeStr) {
        return null;
    }

    private class Element {
        private final Object key;
        private final Object value;

        Element(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }

    class MemcachedAsycOperate
    extends Thread {
        public MemcachedAsycOperate() {
            super("MemcachedAsycOperate Thread");
            this.setDaemon(true);
            this.setPriority(5);
        }

        @Override
        public void run() {
            MemcacheService.this.handleMemcachedAsycOperate();
        }
    }
}

