/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.cache.service.memcache;

import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.framework.cache.config.ICacheConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class MemcacheUtil {
    private static Logger logger = Logger.getLogger(MemcacheUtil.class);
    public static final String MEM_CLIENT_NAME = "eas";
    private List canUsedRemoteCacheserverArray = new ArrayList();
    private int HashAlg = 0;
    private static MemcacheUtil instance;

    public static MemcacheUtil getInstance() {
        if (instance == null) {
            instance = new MemcacheUtil();
        }
        return instance;
    }

    public MemcacheUtil() {
        this.init();
    }

    public String[] getMemcacheServerList() {
        if (this.canUsedRemoteCacheserverArray != null && this.canUsedRemoteCacheserverArray.size() > 0) {
            return this.canUsedRemoteCacheserverArray.toArray(new String[0]);
        }
        return null;
    }

    public int getHashAlg() {
        return this.HashAlg;
    }

    public void init() {
        ICacheConfig config = CacheConfigManager.getConfig();
        if (config != null) {
            String[] tmpList = config.getMemcacheServerList();
            this.HashAlg = config.getMemcacheHashAlg();
            if (tmpList != null && tmpList.length != 0) {
                this.canUsedRemoteCacheserverArray.clear();
                for (int i = 0; i < tmpList.length; ++i) {
                    String server = tmpList[i];
                    try {
                        if (this.canUsedRemoteCacheserverArray.size() != 0 && this.canUsedRemoteCacheserverArray.indexOf(server) != -1) continue;
                        this.canUsedRemoteCacheserverArray.add(server);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Distributed Cache Server  " + server + " connect error: " + e.getMessage()));
                    }
                }
            }
        }
    }
}

