/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.rpcaction;

import com.kingdee.bos.framework.cache.UIActionListener;
import com.kingdee.bos.rpc.transaction.TransactionManager;
import java.lang.reflect.Method;

public class RPCActionMonitor
implements UIActionListener {
    private static Method getSysContextMethod;
    private static Method getUserNameMethod;

    @Override
    public void startAction(String ui, String action) {
        if (ui.contains("CommonQueryPanel")) {
            return;
        }
        String name = ui + "." + action;
        long startTime = System.currentTimeMillis();
        String id = "" + Thread.currentThread().hashCode() + "-" + startTime;
        String userName = this.getUserName();
        TransactionManager.startTransaction((String)name, (String)id, (String)userName);
    }

    @Override
    public void endAction(String ui, String action, long actionTime) {
        if (ui.contains("CommonQueryPanel")) {
            return;
        }
        TransactionManager.endTransaction();
    }

    @Override
    public void clearAction() {
    }

    public String getUserName() {
        String user = "UNKNOWN_USER";
        try {
            if (getSysContextMethod != null && getUserNameMethod != null) {
                Object obj = getSysContextMethod.invoke(null, new Object[0]);
                user = (String)getUserNameMethod.invoke(obj, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return user;
    }

    static {
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.common.client.SysContext");
            getSysContextMethod = clazz.getMethod("getSysContext", new Class[0]);
            getUserNameMethod = clazz.getMethod("getUserName", new Class[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

