/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.stefan.snrpc.SnRpcClient;
import org.stefan.snrpc.SnRpcConnection;
import org.stefan.snrpc.SnRpcConnectionFactory;
import org.stefan.snrpc.serializer.SnRpcRequest;
import org.stefan.snrpc.serializer.SnRpcResponse;
import org.stefan.snrpc.util.Sequence;

public class CommonSnRpcClient
implements SnRpcClient {
    private static final Logger logger = Logger.getLogger(CommonSnRpcClient.class);
    private SnRpcConnectionFactory connectionFactory;
    private SnRpcConnection connection;
    private SnRpcInvoker invoker = new SnRpcInvoker();
    private static Map<String, Object> cachedProxy = new HashMap<String, Object>();

    public CommonSnRpcClient(SnRpcConnectionFactory connectionFactory) {
        if (null == connectionFactory) {
            throw new NullPointerException("connectionFactory is null...");
        }
        this.connectionFactory = connectionFactory;
    }

    public CommonSnRpcClient(SnRpcConnection connection) {
        if (null == connection) {
            throw new NullPointerException("connection is null...");
        }
        this.connection = connection;
    }

    public void destroy() throws Throwable {
        if (null != this.connection) {
            this.connection.close();
        }
    }

    protected String generateRequestID() {
        return Sequence.next() + "";
    }

    private void recycle(SnRpcConnection connection) {
        if (null != connection && null != this.connectionFactory) {
            try {
                this.connectionFactory.recycle(connection);
            }
            catch (Throwable t) {
                logger.warn((Object)"recycle rpc connection fail!", t);
            }
        }
    }

    private SnRpcConnection getConnection() throws Throwable {
        if (null != this.connection) {
            if (!this.connection.isConnected()) {
                this.connection.connection();
            }
            return this.connection;
        }
        try {
            return this.connectionFactory.getConnection();
        }
        catch (Throwable e) {
            return this.connectionFactory.getConnection();
        }
    }

    @Override
    public <T> T proxy(Class<T> interfaceClass) throws Throwable {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException(interfaceClass.getName() + " is not an interface");
        }
        if (!cachedProxy.containsKey(interfaceClass.getName())) {
            cachedProxy.put(interfaceClass.getName(), Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this.invoker));
        }
        return (T)cachedProxy.get(interfaceClass.getName());
    }

    @Override
    public <T> T proxy(Class<T> interfaceClass, String serverInfo) throws Throwable {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException(interfaceClass.getName() + " is not an interface");
        }
        String key = serverInfo + "{" + interfaceClass.getName() + "}";
        if (!cachedProxy.containsKey(key)) {
            cachedProxy.put(key, Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this.invoker));
        }
        return (T)cachedProxy.get(key);
    }

    private class SnRpcInvoker
    implements InvocationHandler {
        private SnRpcInvoker() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String className = method.getDeclaringClass().getName();
            LinkedList<String> parameterTypes = new LinkedList<String>();
            for (Class<?> parameterType : method.getParameterTypes()) {
                parameterTypes.add(parameterType.getName());
            }
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] != null) continue;
                    args[i] = "";
                }
            }
            String requestID = CommonSnRpcClient.this.generateRequestID();
            SnRpcRequest request = new SnRpcRequest(requestID, className, method.getName(), parameterTypes.toArray(new String[0]), args);
            SnRpcConnection connection = null;
            SnRpcResponse response = null;
            try {
                connection = CommonSnRpcClient.this.getConnection();
                response = connection.sendRequest(request);
                for (int i = 0; response == null && i < 3; ++i) {
                    CommonSnRpcClient.this.recycle(connection);
                    connection = CommonSnRpcClient.this.getConnection();
                    response = connection.sendRequest(request);
                }
            }
            catch (Throwable t) {
                logger.error((Object)("send rpc request fail! request: <{}>" + request), t);
                throw new RuntimeException(t);
            }
            finally {
                CommonSnRpcClient.this.recycle(connection);
            }
            if (response == null) {
                return null;
            }
            if (response.getException() != null) {
                throw response.getException();
            }
            if (!response.getRequestID().equals(request.getRequestID())) {
                return null;
            }
            return response.getResult();
        }
    }
}

