/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.client;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.stefan.snrpc.SnRpcConnection;
import org.stefan.snrpc.SnRpcConnectionFactory;

public class PoolableRpcConnectionFactory
implements SnRpcConnectionFactory,
PoolableObjectFactory {
    private SnRpcConnectionFactory connectionFactory;
    private GenericObjectPool pool = new GenericObjectPool((PoolableObjectFactory)this);

    public PoolableRpcConnectionFactory() {
        this.initPool();
    }

    public PoolableRpcConnectionFactory(SnRpcConnectionFactory factory) {
        if (null == factory) {
            throw new NullPointerException("factory");
        }
        this.connectionFactory = factory;
        this.initPool();
    }

    private void initPool() {
        this.pool.setMaxIdle(10);
        this.pool.setMaxActive(50);
        this.pool.setMaxWait(10000L);
    }

    @Override
    public SnRpcConnection getConnection() throws Throwable {
        return (SnRpcConnection)this.pool.borrowObject();
    }

    @Override
    public void recycle(SnRpcConnection connection) throws Throwable {
        if (null != connection) {
            connection.reset();
            this.pool.returnObject((Object)connection);
        }
    }

    public void destroy() throws Throwable {
        this.pool.close();
    }

    public void activateObject(Object o) throws Exception {
        SnRpcConnection connection = (SnRpcConnection)o;
        try {
            connection.connection();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public void destroyObject(Object o) throws Exception {
        SnRpcConnection connection = (SnRpcConnection)o;
        try {
            connection.close();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public SnRpcConnection makeObject() throws Exception {
        try {
            return this.connectionFactory.getConnection();
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public void passivateObject(Object connection) throws Exception {
    }

    public boolean validateObject(Object o) {
        SnRpcConnection connection = (SnRpcConnection)o;
        return connection.isConnected() && !connection.isClosed();
    }

    public void setLifo(boolean lifo) {
    }

    public void setMaxActive(int maxActive) {
        this.pool.setMaxActive(maxActive);
    }

    public void setMaxIdle(int maxIdle) {
        this.pool.setMaxIdle(maxIdle);
    }

    public void setMaxWait(long maxWait) {
        this.pool.setMaxWait(maxWait);
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.pool.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    public void setMinIdle(int minIdle) {
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.pool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.pool.setTestOnBorrow(testOnBorrow);
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.pool.setTestOnReturn(testOnReturn);
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.pool.setTestWhileIdle(testWhileIdle);
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.pool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public void setWhenExhaustedAction(byte whenExhaustedAction) {
        this.pool.setWhenExhaustedAction(whenExhaustedAction);
    }
}

