/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.stefan.snrpc.SnRpcConnection;
import org.stefan.snrpc.serializer.ProtobufSerializer;
import org.stefan.snrpc.serializer.SnRpcRequest;
import org.stefan.snrpc.serializer.SnRpcRequestEncoder;
import org.stefan.snrpc.serializer.SnRpcResponse;
import org.stefan.snrpc.serializer.SnRpcResponseDecoder;

@ChannelHandler.Sharable
public class SnNettyRpcConnection
extends SimpleChannelInboundHandler<SnRpcResponse>
implements SnRpcConnection {
    private static final Logger logger = Logger.getLogger(SnNettyRpcConnection.class);
    private boolean connected;
    private volatile SnRpcResponse response;
    private volatile SnRpcRequest request;
    String host;
    int port;
    CountDownLatch latchlocal = null;
    Channel channel = null;
    static AtomicInteger ai = new AtomicInteger();
    private static EventLoopGroup group = new NioEventLoopGroup(10);

    public SnNettyRpcConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public SnRpcResponse sendRequest(SnRpcRequest request) throws Throwable {
        this.request = request;
        this.latchlocal = new CountDownLatch(1);
        if (this.channel == null) {
            this.channel = this.getChannel();
        }
        if (!this.channel.isActive()) {
            this.channel.disconnect();
            this.channel.close();
            this.channel = this.getChannel();
        }
        this.channel.writeAndFlush((Object)request).sync();
        this.latchlocal.await(5000L, TimeUnit.MILLISECONDS);
        SnRpcResponse tmpResp = this.response;
        this.response = null;
        request = null;
        return tmpResp;
    }

    private Channel getChannel() throws InterruptedException {
        ai.incrementAndGet();
        this.getBootstrap();
        Bootstrap bootstrap = this.getBootstrap();
        ChannelFuture future = bootstrap.connect(this.host, this.port).sync();
        Channel channel = future.channel();
        return channel;
    }

    private Bootstrap getBootstrap() {
        if (group.isShutdown() || group.isTerminated()) {
            group.shutdownGracefully();
            group = new NioEventLoopGroup(10);
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(group);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline p = channel.pipeline();
                if (p.get("decoder") == null) {
                    p.addLast("decoder", (ChannelHandler)new SnRpcRequestEncoder(ProtobufSerializer.getInstance()));
                }
                if (p.get("encoder") == null) {
                    p.addLast("encoder", (ChannelHandler)new SnRpcResponseDecoder(ProtobufSerializer.getInstance()));
                }
                if (p.get("snConnection") == null) {
                    p.addLast("snConnection", (ChannelHandler)SnNettyRpcConnection.this);
                }
            }
        });
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        return bootstrap;
    }

    @Override
    public void connection() throws Throwable {
    }

    @Override
    public void close() throws Throwable {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public void reset() {
        this.response = null;
        this.request = null;
    }

    protected void channelRead0(ChannelHandlerContext paramChannelHandlerContext, SnRpcResponse paramI) throws Exception {
        if (paramI != null && this.request != null && paramI.getRequestID().equals(this.request.getRequestID())) {
            this.response = paramI;
        }
        if (this.latchlocal != null) {
            this.latchlocal.countDown();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error((Object)"api caught exception", cause);
        ctx.close();
    }
}

