/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.serializer;

import io.protostuff.LinkedBuffer;
import io.protostuff.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.stefan.snrpc.exception.SerializerException;
import org.stefan.snrpc.serializer.ClientSerializer;
import org.stefan.snrpc.serializer.ServerSerializer;
import org.stefan.snrpc.serializer.SnRpcRequest;
import org.stefan.snrpc.serializer.SnRpcResponse;
import org.stefan.snrpc.util.BufferCache;
import org.stefan.snrpc.util.IOUtils;
import org.stefan.snrpc.util.SchemaCache;

public abstract class AbstractProtostuffSerializer
implements ClientSerializer,
ServerSerializer {
    protected abstract <T> int writeObject(LinkedBuffer var1, T var2, Schema<T> var3);

    protected abstract <T> void parseObject(byte[] var1, T var2, Schema<T> var3);

    @Override
    public SnRpcRequest decodeRequest(InputStream inputStream) throws SerializerException, IOException {
        return this.decode(inputStream, new SnRpcRequest());
    }

    @Override
    public void encodeResponse(OutputStream outputStream, SnRpcResponse result) throws SerializerException, IOException {
        this.encode(outputStream, result);
    }

    @Override
    public SnRpcResponse decodeResponse(InputStream inputStream) throws SerializerException, IOException {
        return this.decode(inputStream, new SnRpcResponse());
    }

    @Override
    public void encodeRequest(OutputStream outputStream, SnRpcRequest request) throws SerializerException, IOException {
        this.encode(outputStream, request);
    }

    public <T> void encode(OutputStream out, T object) throws IOException {
        LinkedBuffer buffer = BufferCache.getBuffer();
        Object schema = null;
        schema = null == object ? SchemaCache.getSchema(Object.class) : SchemaCache.getSchema(object.getClass());
        int length = this.writeObject(buffer, object, (Schema<T>)schema);
        IOUtils.writeInt(out, length);
        LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
    }

    public <T> T decode(InputStream in, T template) throws IOException {
        Schema<?> schema = SchemaCache.getSchema(template.getClass());
        int length = IOUtils.readInt(in);
        byte[] bytes = new byte[length];
        IOUtils.readFully(in, bytes, 0, length);
        this.parseObject(bytes, template, schema);
        return template;
    }
}

