/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.serializer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.InputStream;
import java.util.List;
import org.stefan.snrpc.serializer.ServerSerializer;

public class SnRpcRequestDecoder
extends ByteToMessageDecoder {
    private final ServerSerializer serializer;

    public SnRpcRequestDecoder(ServerSerializer serializer) {
        this.serializer = serializer;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (in.readableBytes() < 4) {
            return;
        }
        in.markReaderIndex();
        int dataLength = in.readInt();
        if (in.readableBytes() < dataLength) {
            in.resetReaderIndex();
            return;
        }
        ByteBufInputStream bbi = new ByteBufInputStream(in);
        out.add(this.serializer.decodeRequest((InputStream)bbi));
    }
}

