/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.serializer;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.ByteArrayOutputStream;
import org.stefan.snrpc.serializer.ClientSerializer;
import org.stefan.snrpc.serializer.SnRpcRequest;

public class SnRpcRequestEncoder
extends MessageToByteEncoder<SnRpcRequest> {
    private final ClientSerializer serializer;

    public SnRpcRequestEncoder(ClientSerializer serializer) {
        this.serializer = serializer;
    }

    public void encode(ChannelHandlerContext ctx, SnRpcRequest in, ByteBuf out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
        this.serializer.encodeRequest(baos, in);
        byte[] data = baos.toByteArray();
        out.writeInt(data.length);
        out.writeBytes(data);
    }
}

