/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.serializer;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.ByteArrayOutputStream;
import org.stefan.snrpc.serializer.ServerSerializer;
import org.stefan.snrpc.serializer.SnRpcResponse;

public class SnRpcResponseEncoder
extends MessageToByteEncoder<SnRpcResponse> {
    private final ServerSerializer serializer;

    public SnRpcResponseEncoder(ServerSerializer serializer) {
        this.serializer = serializer;
    }

    protected void encode(ChannelHandlerContext ctx, SnRpcResponse in, ByteBuf out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
        this.serializer.encodeResponse(baos, in);
        byte[] data = baos.toByteArray();
        out.writeInt(data.length);
        out.writeBytes(data);
    }
}

