/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.util;

import java.util.HashMap;
import java.util.Map;

public class HandlerMapper {
    public static Map<String, Object> getHandlerMap(Object ... handlers) {
        HashMap<String, Object> handlerMap = new HashMap<String, Object>();
        for (Object handler : handlers) {
            Class<?>[] interfaces;
            for (Class<?> iface : interfaces = handler.getClass().getInterfaces()) {
                String interfaceName = iface.getName();
                if (HandlerMapper.ignore(interfaceName) || null == handlerMap.put(interfaceName, handler)) continue;
                throw new IllegalArgumentException("more than one handler for the interface [" + interfaceName + "]");
            }
        }
        return handlerMap;
    }

    private static boolean ignore(String interfaceName) {
        if (interfaceName.startsWith("java.")) {
            return true;
        }
        if (interfaceName.startsWith("javax.")) {
            return true;
        }
        if (interfaceName.startsWith("sun.")) {
            return true;
        }
        return interfaceName.startsWith("com.sun.");
    }
}

