/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.util;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class IOUtils {
    public static void readFully(InputStream in, byte[] bytes, int offset, int length) throws IOException {
        int count;
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < length; n += count) {
            count = in.read(bytes, offset + n, length - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public static void writeInt(OutputStream out, int value) throws IOException {
        out.write(value >>> 24 & 0xFF);
        out.write(value >>> 16 & 0xFF);
        out.write(value >>> 8 & 0xFF);
        out.write(value >>> 0 & 0xFF);
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void closeQuietly(Closeable closeable) {
        if (null == closeable) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket socket) {
        if (null == socket) {
            return;
        }
        if (!socket.isInputShutdown()) {
            try {
                socket.shutdownInput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!socket.isOutputShutdown()) {
            try {
                socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

