/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.util;

import java.util.HashMap;
import java.util.Map;

public class MessageFormatter {
    public static final String DEFAULT_PLACE_HOLDER = "{}";
    public static final char DEFAULT_ESCAPE_CHAR = '\\';

    public static String format(String msgPattern, Object[] args) {
        return MessageFormatter.format(msgPattern, DEFAULT_PLACE_HOLDER, '\\', args);
    }

    public static String format(String msgPattern, String placeholder, Object[] args) {
        return MessageFormatter.format(msgPattern, placeholder, '\\', args);
    }

    public static String format(String msgPattern, String placeholder, char escapeChar, Object[] args) {
        if (null == msgPattern || msgPattern.length() == 0) {
            return null;
        }
        if (null == args || args.length == 0) {
            return msgPattern;
        }
        if (null == placeholder || "".equals(placeholder)) {
            return msgPattern;
        }
        int lastMatchedIndex = 0;
        int currentMatchedIndex = 0;
        StringBuilder strbuf = new StringBuilder(msgPattern.length() + 64);
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            currentMatchedIndex = msgPattern.indexOf(placeholder, lastMatchedIndex);
            if (-1 == currentMatchedIndex) {
                if (0 == lastMatchedIndex) {
                    return msgPattern;
                }
                strbuf.append(msgPattern.substring(lastMatchedIndex, msgPattern.length()));
                return strbuf.toString();
            }
            int cnt = MessageFormatter.countSuccessiveEscapeChar(msgPattern, escapeChar, currentMatchedIndex, lastMatchedIndex);
            if (0 == cnt) {
                strbuf.append(msgPattern.substring(lastMatchedIndex, currentMatchedIndex));
                MessageFormatter.deeplyAppendParameter(strbuf, args[argIndex], new HashMap());
                lastMatchedIndex = currentMatchedIndex + placeholder.length();
                continue;
            }
            int escapeItselfCnt = cnt / 2;
            strbuf.append(msgPattern.substring(lastMatchedIndex, currentMatchedIndex - cnt + escapeItselfCnt));
            if (cnt % 2 != 0) {
                --argIndex;
                strbuf.append(placeholder.charAt(0));
                lastMatchedIndex = currentMatchedIndex + 1;
                continue;
            }
            MessageFormatter.deeplyAppendParameter(strbuf, args[argIndex], new HashMap());
            lastMatchedIndex = currentMatchedIndex + placeholder.length();
        }
        strbuf.append(msgPattern.substring(lastMatchedIndex, msgPattern.length()));
        return strbuf.toString();
    }

    private static int countSuccessiveEscapeChar(String msgPattern, char escapeChar, int delimeterStartIndex, int delimeterStopIndex) {
        if (0 == delimeterStartIndex) {
            return 0;
        }
        int cnt = 0;
        for (int i = delimeterStartIndex - 1; i >= delimeterStopIndex && msgPattern.charAt(i) == escapeChar; --i) {
            ++cnt;
        }
        return cnt;
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Map seenMap) {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(sbuf, o);
        } else if (o instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o);
        } else if (o instanceof byte[]) {
            MessageFormatter.byteArrayAppend(sbuf, (byte[])o);
        } else if (o instanceof char[]) {
            MessageFormatter.charArrayAppend(sbuf, (char[])o);
        } else if (o instanceof short[]) {
            MessageFormatter.shortArrayAppend(sbuf, (short[])o);
        } else if (o instanceof int[]) {
            MessageFormatter.intArrayAppend(sbuf, (int[])o);
        } else if (o instanceof long[]) {
            MessageFormatter.longArrayAppend(sbuf, (long[])o);
        } else if (o instanceof float[]) {
            MessageFormatter.floatArrayAppend(sbuf, (float[])o);
        } else if (o instanceof double[]) {
            MessageFormatter.doubleArrayAppend(sbuf, (double[])o);
        } else {
            MessageFormatter.objectArrayAppend(sbuf, (Object[])o, seenMap);
        }
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o) {
        try {
            String oAsString = o.toString();
            sbuf.append(oAsString);
        }
        catch (Throwable t) {
            System.err.println("Failed toString() invocation on an object of type [" + o.getClass().getName() + "]");
            t.printStackTrace();
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Map seenMap) {
        sbuf.append('[');
        if (!seenMap.containsKey(a)) {
            seenMap.put(a, null);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                MessageFormatter.deeplyAppendParameter(sbuf, a[i], seenMap);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            seenMap.remove(a);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }
}

