/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.stefan.snrpc.util.LRUMap;

public class ReflectionCache {
    private static final Map<String, Class<?>> PRIMITIVE_CLASS = new HashMap();
    private static final LRUMap<String, Class<?>> CLASS_CACHE = new LRUMap(128);
    private static final LRUMap<String, Method> METHOD_CACHE = new LRUMap(1024);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getClass(String className) throws ClassNotFoundException {
        Class<?> clazz = CLASS_CACHE.get(className);
        if (null != clazz) {
            return clazz;
        }
        LRUMap<String, Class<?>> lRUMap = CLASS_CACHE;
        synchronized (lRUMap) {
            if (null == CLASS_CACHE.get(className)) {
                clazz = PRIMITIVE_CLASS.get(className);
                if (null == clazz) {
                    clazz = Class.forName(className);
                }
                CLASS_CACHE.put(className, clazz);
                return clazz;
            }
            return CLASS_CACHE.get(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getMethod(String className, String methodName, String[] parameterTypes) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        String key = className + "-" + methodName + "-" + ReflectionCache.join(parameterTypes, ";");
        Method method = METHOD_CACHE.get(key);
        if (null != method) {
            return method;
        }
        LRUMap<String, Method> lRUMap = METHOD_CACHE;
        synchronized (lRUMap) {
            if (null == METHOD_CACHE.get(key)) {
                Class<?> clazz = ReflectionCache.getClass(className);
                Class[] parameterClasses = new Class[parameterTypes.length];
                for (int i = 0; i < parameterClasses.length; ++i) {
                    parameterClasses[i] = ReflectionCache.getClass(parameterTypes[i]);
                }
                method = clazz.getMethod(methodName, parameterClasses);
                METHOD_CACHE.put(key, method);
                return method;
            }
            return METHOD_CACHE.get(key);
        }
    }

    private static String join(String[] strs, String seperator) {
        if (null == strs || 0 == strs.length) {
            return "";
        }
        StringBuilder sb = new StringBuilder(1024);
        sb.append(strs[0]);
        for (int i = 1; i < strs.length; ++i) {
            sb.append(seperator).append(strs[i]);
        }
        return sb.toString();
    }

    static {
        PRIMITIVE_CLASS.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASS.put("byte", Byte.TYPE);
        PRIMITIVE_CLASS.put("short", Short.TYPE);
        PRIMITIVE_CLASS.put("int", Integer.TYPE);
        PRIMITIVE_CLASS.put("long", Long.TYPE);
        PRIMITIVE_CLASS.put("long", Long.TYPE);
        PRIMITIVE_CLASS.put("float", Float.TYPE);
        PRIMITIVE_CLASS.put("double", Double.TYPE);
        PRIMITIVE_CLASS.put("void", Void.TYPE);
        CLASS_CACHE.putAll(PRIMITIVE_CLASS);
    }
}

