/*
 * Decompiled with CFR 0.152.
 */
package org.stefan.snrpc.util;

import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import org.stefan.snrpc.serializer.SnRpcRequest;
import org.stefan.snrpc.serializer.SnRpcResponse;
import org.stefan.snrpc.util.LRUMap;

public class SchemaCache {
    private static final LRUMap<String, Schema<?>> SCHEMA_CACHE = new LRUMap(4096);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Schema<T> getSchema(Class<T> clazz) {
        String className = clazz.getName();
        Schema schema = SCHEMA_CACHE.get(className);
        if (null != schema) {
            return schema;
        }
        LRUMap<String, Schema<?>> lRUMap = SCHEMA_CACHE;
        synchronized (lRUMap) {
            if (null == SCHEMA_CACHE.get(className)) {
                schema = RuntimeSchema.getSchema(clazz);
                SCHEMA_CACHE.put(className, schema);
                return schema;
            }
            return SCHEMA_CACHE.get(className);
        }
    }

    public static Schema<SnRpcRequest> getSchema(SnRpcRequest request) {
        Schema<SnRpcRequest> schema = SchemaCache.getSchema(SnRpcRequest.class);
        Object[] parameters = request.getParameters();
        if (null != parameters && parameters.length > 0) {
            for (Object param : parameters) {
                if (null == param) continue;
                SchemaCache.getSchema(param.getClass());
            }
        }
        return schema;
    }

    public static Schema<SnRpcResponse> getSchema(SnRpcResponse response) {
        Schema<SnRpcResponse> schema = SchemaCache.getSchema(SnRpcResponse.class);
        if (response.getException() != null) {
            SchemaCache.getSchema(response.getException().getClass());
        }
        if (response.getResult() != null) {
            SchemaCache.getSchema(response.getResult().getClass());
        }
        return schema;
    }
}

