/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug;

import com.kingdee.bos.kscript.debug.DebugTracer;
import com.kingdee.bos.kscript.debug.IDebugContext;
import com.kingdee.bos.kscript.debug.IDebugEnv;
import com.kingdee.bos.kscript.debug.IDebugTracer;
import com.kingdee.bos.kscript.runtime.Interpreter;

public class DebugFactory {
    private static final ThreadLocal threadTracers = new ThreadLocal();

    public static synchronized void initializeInterpreter(IDebugEnv debugEnv, Interpreter interpreter) {
        if (debugEnv != null) {
            DebugTracer tracer = new DebugTracer(debugEnv, interpreter);
            interpreter.setTracer(tracer);
        }
    }

    public static IDebugTracer setCurrentTracer(IDebugTracer tracer) {
        IDebugTracer old = (IDebugTracer)threadTracers.get();
        threadTracers.set(tracer);
        return old;
    }

    public static IDebugTracer getCurrentTracer() {
        return (IDebugTracer)threadTracers.get();
    }

    public static IDebugContext getCurrentDebugContext() {
        Object x = threadTracers.get();
        if (x != null && x instanceof IDebugContext) {
            return (IDebugContext)x;
        }
        return null;
    }
}

