/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.runtime;

import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.IObjectLoaderProvider;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.runtime.FuncExecTimeInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.ThreadLocalCache;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CachedFunctionProvider
implements IFunctionProvider {
    private static IObjectLoaderProvider bizObjectProvider = null;
    public static final String FLAG_FUNC_TIMES = "_FUNC_TIMES_";
    private static final Object NULL;
    private static final Object CONTEXT;
    private final Map cache;
    private final Map funcTimesMap;
    private static final ThreadLocal threadRecord;
    private final IFunctionProvider realProvider;

    public static IObjectLoaderProvider getBizObjectProvider() {
        return bizObjectProvider;
    }

    public static void setBizObjectProvider(IObjectLoaderProvider bizObjectProvider) {
        CachedFunctionProvider.bizObjectProvider = bizObjectProvider;
    }

    public CachedFunctionProvider(IFunctionProvider realProvider, String cacheRegionName) {
        this.cache = ThreadLocalCache.getRegion((String)cacheRegionName);
        this.funcTimesMap = ThreadLocalCache.getRegion((String)(cacheRegionName + FLAG_FUNC_TIMES));
        this.realProvider = realProvider;
    }

    public static void setRecordFuncTime(boolean isRecordFuncTime) {
        threadRecord.set(isRecordFuncTime);
    }

    private boolean isRecordFuncTime() {
        if (threadRecord.get() != null) {
            return (Boolean)threadRecord.get();
        }
        return false;
    }

    public void clear() {
        this.funcTimesMap.clear();
    }

    public Map getFuncTimeMap() {
        return this.funcTimesMap;
    }

    private void recordFuncTime(String funcName, long time, boolean isCached) {
        long times;
        if (!this.isRecordFuncTime()) {
            return;
        }
        long l = times = isCached ? 0L : 1L;
        if (this.funcTimesMap.containsKey(funcName)) {
            FuncExecTimeInfo info = (FuncExecTimeInfo)this.funcTimesMap.get(funcName);
            info.add(times, time);
        } else {
            FuncExecTimeInfo info = new FuncExecTimeInfo(funcName, 1L, time);
            this.funcTimesMap.put(funcName, info);
        }
    }

    @Override
    public Object evalFunction(String funcName, List paramList) throws KScriptException {
        FunctionDesc funcDesc = new FunctionDesc(this.realProvider.getClass().getName(), funcName, paramList);
        long start = System.currentTimeMillis();
        Object retVal = null;
        if ((funcName.equals("__BOTGetAccountFromKacAndBaseData") || funcName.equals("__BOTGetAccountFromKacAndBaseDataId")) && this.cache.containsKey(funcDesc.getKey())) {
            retVal = this.cache.get(funcDesc.getKey());
            this.recordFuncTime(funcName, System.currentTimeMillis() - start, true);
        } else if (this.cache.containsKey(funcDesc)) {
            retVal = this.cache.get(funcDesc);
            this.recordFuncTime(funcName, System.currentTimeMillis() - start, true);
        } else {
            retVal = this.realProvider.evalFunction(funcName, paramList);
            if (funcName.equals("__BOTGetAccountFromKacAndBaseData") || funcName.equals("__BOTGetAccountFromKacAndBaseDataId")) {
                this.cache.put(funcDesc.getKey(), retVal);
            } else {
                this.cache.put(funcDesc, retVal);
            }
            this.recordFuncTime(funcName, System.currentTimeMillis() - start, false);
        }
        return retVal;
    }

    @Override
    public boolean existFunction(String funcName) {
        return this.realProvider.existFunction(funcName);
    }

    public void cacheFunction(String funcName, List paramList, Object retVal) {
        FunctionDesc funcDesc = new FunctionDesc(this.realProvider.getClass().getName(), funcName, paramList);
        if (funcName.equals("__BOTGetAccountFromKacAndBaseData") || funcName.equals("__BOTGetAccountFromKacAndBaseDataId")) {
            String key = funcDesc.getKey();
            this.cache.put(key, retVal);
        } else {
            this.cache.put(funcDesc, retVal);
        }
    }

    static {
        try {
            bizObjectProvider = (IObjectLoaderProvider)Class.forName("com.kingdee.bos.dao.ormapping.KscriptObjectLoaderProvider").newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        NULL = new Object();
        CONTEXT = new Object();
        threadRecord = new ThreadLocal();
    }

    private static final class FunctionDesc {
        private final String providerName;
        private final String functionName;
        private final Object[] parameterValues;
        private int hash = 0;

        public FunctionDesc(String providerName, String name, List paramList) {
            this.providerName = providerName;
            this.functionName = name;
            this.parameterValues = new Object[paramList.size()];
            int n = this.parameterValues.length;
            for (int i = 0; i < n; ++i) {
                this.parameterValues[i] = this.getRealValue(paramList.get(i));
            }
        }

        public String getKey() {
            StringBuilder tempHash = new StringBuilder();
            tempHash.append(this.providerName + "|" + this.functionName);
            for (int i = 1; i < this.parameterValues.length; ++i) {
                tempHash.append("|").append(this.getRealValue(this.parameterValues[i]));
            }
            return tempHash.toString();
        }

        private Object getRealValue(Object orig) {
            Object pkValue;
            String pkField;
            if (orig == null || "null".equals(orig)) {
                return NULL;
            }
            if (bizObjectProvider != null && bizObjectProvider.isBOSContext(orig)) {
                return CONTEXT;
            }
            if (bizObjectProvider != null && bizObjectProvider.isObjectPK(orig)) {
                return orig.toString();
            }
            if (bizObjectProvider != null && bizObjectProvider.isObjectValue(orig) && !StringUtils.isEmpty((String)(pkField = bizObjectProvider.getObjectValuePKField(orig))) && (pkValue = bizObjectProvider.getObjectValuePropValueByName(orig, pkField)) != null) {
                return pkValue;
            }
            if (bizObjectProvider != null && bizObjectProvider.isObjectCollection(orig)) {
                Object[] arr = new Object[bizObjectProvider.getObjectCollectionSize(orig)];
                int n = arr.length;
                for (int i = 0; i < n; ++i) {
                    arr[i] = this.getRealValue(bizObjectProvider.getObjectCollectionChildByIndex(orig, i));
                }
                return arr;
            }
            return orig;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.functionName == null ? 0 : this.functionName.hashCode());
            result = 31 * result + Arrays.hashCode(this.parameterValues);
            result = 31 * result + (this.providerName == null ? 0 : this.providerName.hashCode());
            if (this.hash == 0) {
                this.hash = result;
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionDesc other = (FunctionDesc)obj;
            if (this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName)) {
                return false;
            }
            if (!Arrays.equals(this.parameterValues, other.parameterValues)) {
                return false;
            }
            return !(this.providerName == null ? other.providerName != null : !this.providerName.equals(other.providerName));
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append("providerName:");
            sbuf.append(this.providerName);
            sbuf.append(";functionName:");
            sbuf.append(this.functionName);
            sbuf.append(";");
            int n = this.parameterValues.length;
            for (int i = 0; i < n; ++i) {
                sbuf.append(this.parameterValues[i] == null ? "" : this.parameterValues[i].toString());
                if (i >= n - 1) continue;
                sbuf.append(",");
            }
            return sbuf.toString();
        }
    }
}

