/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.remote;

import com.kingdee.bos.kscript.debug.remote.DebugRemoteContext;
import com.kingdee.bos.util.lightremote.RemoteContext;
import com.kingdee.bos.util.lightremote.RemoteServer;
import java.io.IOException;
import java.net.Socket;
import org.apache.log4j.BasicConfigurator;

public class DebugServer
extends RemoteServer {
    public static final int DEFAULT_PORT = 10009;
    private static DebugServer runningServer = null;

    public static synchronized DebugServer getRunningServer() {
        return runningServer;
    }

    public static synchronized void shutdownServer() {
        if (runningServer != null) {
            runningServer.close();
            runningServer = null;
        }
    }

    public static synchronized void startServer(int port) throws IOException {
        if (runningServer != null) {
            throw new IOException("DebugServer already running.");
        }
        runningServer = new DebugServer(port);
        runningServer.start();
    }

    @Override
    protected void finalClose() {
        if (runningServer == this) {
            DebugServer.shutdownServer();
        }
    }

    public static void startServer() throws IOException {
        DebugServer.startServer(10009);
    }

    private DebugServer(int port) throws IOException {
        super(port);
    }

    @Override
    public String toString() {
        return "kdscript debug server";
    }

    @Override
    protected RemoteContext createContext(Socket sock) throws Exception {
        return new DebugRemoteContext(sock);
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            DebugServer.startServer();
            DebugServer.getRunningServer().join();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

