/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.remote;

import com.kingdee.bos.kscript.debug.DebugEnv;
import com.kingdee.bos.kscript.debug.DebugException;
import com.kingdee.bos.kscript.debug.remote.DebugServer;
import com.kingdee.bos.kscript.debug.remote.IDebugServerController;
import com.kingdee.bos.kscript.debug.remote.IDebugServerControllerModel;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import java.io.IOException;
import java.net.InetAddress;

public class DebugServerController
implements IDebugServerControllerModel {
    DebugServer server = null;

    public IORMModel queryInterface(Class model) throws ORMCoreException {
        if (model == IDebugServerController.class || model == IORMModel.class) {
            return this;
        }
        return null;
    }

    @Override
    public InetAddress getLocalAddress() throws IOException {
        InetAddress a = this.server.server.getInetAddress();
        if (!a.isAnyLocalAddress()) {
            return a;
        }
        return InetAddress.getLocalHost();
    }

    @Override
    public int getLocalPort() {
        return this.server.server.getLocalPort();
    }

    @Override
    public void shutdownServer() {
        DebugServer.shutdownServer();
        this.server = null;
    }

    @Override
    public void startDebugServer(int startPort, int endPort) throws Exception {
        if (DebugEnv.getDebugEnv() != null) {
            throw new DebugException("a debuger already registered.");
        }
        if (this.server != null) {
            return;
        }
        if (startPort == 0) {
            endPort = 0;
        }
        if (endPort < startPort) {
            endPort = startPort;
        }
        if (startPort == 0 && endPort == 0) {
            DebugServer.startServer(0);
        } else {
            Exception le = null;
            try {
                int port = startPort;
                if (port <= endPort) {
                    DebugServer.startServer(port);
                    le = null;
                }
            }
            catch (Exception ex) {
                le = ex;
            }
            if (le != null) {
                throw le;
            }
        }
        this.server = DebugServer.getRunningServer();
        this.server.waitForStart();
    }
}

