/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.remote;

import com.kingdee.bos.kscript.debug.remote.DebugServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;

public class KScriptDebugListener
implements ServletContextListener {
    private int port;
    private static final Logger logger = Logger.getLogger(KScriptDebugListener.class);
    private static final String CONFIGFILE_NAME = "kscripttool.properties";
    private static final String EAS_DEPLOY = "eas.deploy";
    private static final String DEBUG_SERVER_PORT = "debugserverport";
    private Properties properties = new Properties();

    public KScriptDebugListener() {
        this.loadConfig();
        try {
            this.port = Integer.parseInt(this.properties.getProperty(DEBUG_SERVER_PORT));
        }
        catch (Exception ex) {
            logger.error((Object)"KScriptDebugServiceConfig get debug port error, use default port: 10009", (Throwable)ex);
            this.port = 10009;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadConfig() {
        if (System.getProperty(EAS_DEPLOY) != null || !"".equalsIgnoreCase(System.getProperty(EAS_DEPLOY).trim())) {
            String configFilePath = System.getProperty(EAS_DEPLOY) + "/" + CONFIGFILE_NAME;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(configFilePath));
                this.properties.load(inputStream);
                if (inputStream == null) return;
                this.safeClose(inputStream);
                return;
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"KScriptDebugServiceConfig.loadConfig error", (Throwable)e);
                if (inputStream == null) return;
                this.safeClose(inputStream);
                return;
            }
            catch (IOException e2) {
                logger.error((Object)"KScriptDebugServiceConfig.loadConfig error", (Throwable)e2);
                if (inputStream == null) return;
                this.safeClose(inputStream);
                return;
                {
                    catch (Throwable throwable) {
                        if (inputStream == null) throw throwable;
                        this.safeClose(inputStream);
                        throw throwable;
                    }
                }
            }
        } else {
            logger.error((Object)"can't find the value of 'eas.deploy(system property)',please check the enviroment");
        }
    }

    private void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                logger.error((Object)"KScriptDebugServiceConfig.loadConfig error", (Throwable)e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        DebugServer.shutdownServer();
        logger.info((Object)("KScript Debug Server[" + this.port + "] shutdown"));
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            DebugServer.startServer(this.port);
            logger.info((Object)("KScript Debug Server[" + this.port + "] started"));
        }
        catch (IOException e) {
            logger.error((Object)("KScript Debug Server[" + this.port + "] started failed"), (Throwable)e);
        }
    }
}

