/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.ui.DebugUI;
import com.kingdee.bos.kscript.debug.ui.IScript;
import com.kingdee.bos.kscript.debug.ui.IScriptProvider;
import com.kingdee.bos.kscript.parser.Source;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;

public class FileScriptProvider
implements IScriptProvider {
    @Override
    public IScript browseScript(Object owner) throws Exception {
        File file = DebugUI.props.selectFile("scriptfile", "KScript File");
        if (file == null) {
            return null;
        }
        return new Script(file);
    }

    @Override
    public String getName() {
        return "filescript";
    }

    public Icon getMenuIcon() {
        return null;
    }

    @Override
    public String getMenuText() {
        return "Load kscript file...";
    }

    public String getMenuTipText() {
        return "load kscript in filesystem.";
    }

    @Override
    public IScript loadScript(String key) throws Exception {
        File file = new File(key);
        if (!file.exists()) {
            return null;
        }
        return new Script(file);
    }

    public class Script
    implements IScript {
        public final Source source;
        public final File file;
        long lastModified;

        public Script(File file) throws IOException {
            this.file = file;
            this.source = new Source(file);
            this.lastModified = file.lastModified();
        }

        @Override
        public String getDescription() {
            return this.file.getAbsolutePath();
        }

        @Override
        public String getKey() {
            return this.file.getAbsolutePath();
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public IScriptProvider getProvider() {
            return FileScriptProvider.this;
        }

        @Override
        public Source getSource() {
            return this.source;
        }

        @Override
        public boolean isModified() {
            return this.lastModified != this.file.lastModified();
        }

        @Override
        public IScript reload() throws Exception {
            return new Script(this.file);
        }
    }
}

