/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.kscript.debug.ui;

import com.kingdee.bos.kscript.debug.IValue;
import com.kingdee.bos.kscript.debug.ui.DebugPanel;
import com.kingdee.bos.kscript.debug.ui.DefaultEditMenu;
import com.kingdee.bos.kscript.debug.ui.StackPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ScriptPanel
extends JPanel {
    public DebugPanel debugPanel;
    public JTextArea text = new JTextArea();
    private DefaultEditMenu editMenu;
    private DefaultEditMenu editMenu2;
    private JPanel pane = new JPanel(null);
    private JButton btnEval = new JButton("Eval");
    private JTextField result = new JTextField();
    public String title;
    public StackPanel parent;
    public static final String EVAL = "Eval";
    public static final String CLOSE_PANEL = "Close Panel";
    public static final String NEW_PANEL = "New Eval Panel";

    public ScriptPanel(String title, StackPanel parent, DebugPanel debugPanel) {
        super(new BorderLayout());
        this.parent = parent;
        this.title = title;
        this.debugPanel = debugPanel;
        this.editMenu = new DefaultEditMenu("script", this.text, true){

            @Override
            protected void fileLoaded(File file) {
                ScriptPanel.this.changeTitle(file);
            }

            @Override
            protected void fileSaved(File file) {
                ScriptPanel.this.changeTitle(file);
            }

            @Override
            protected void buildActionMenu(JPopupMenu menu) {
                super.buildActionMenu(menu);
                menu.addSeparator();
                super.addAction(menu, ScriptPanel.EVAL);
                menu.addSeparator();
                super.addAction(menu, ScriptPanel.NEW_PANEL);
                super.addAction(menu, ScriptPanel.CLOSE_PANEL);
            }

            @Override
            protected void extandActionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(ScriptPanel.EVAL)) {
                    ScriptPanel.this.eval();
                } else if (e.getActionCommand().equals(ScriptPanel.NEW_PANEL)) {
                    ScriptPanel p = ScriptPanel.this.parent.addScriptPanel();
                    p.text.setText(ScriptPanel.this.text.getText());
                } else if (e.getActionCommand().equals(ScriptPanel.CLOSE_PANEL)) {
                    ScriptPanel.this.closePanel();
                } else {
                    super.extandActionPerformed(e);
                }
            }

            @Override
            protected boolean isExtandActionEnabled(String action) {
                if (action.equals(ScriptPanel.EVAL)) {
                    return ScriptPanel.this.canEval();
                }
                if (action.equals(ScriptPanel.NEW_PANEL)) {
                    return true;
                }
                if (action.equals(ScriptPanel.CLOSE_PANEL)) {
                    return ScriptPanel.this.parent.getScriptPanelCount() > 1;
                }
                return super.isExtandActionEnabled(action);
            }
        };
        this.editMenu.supportLoadSave = true;
        this.editMenu2 = new DefaultEditMenu("result", this.result, false);
        JScrollPane sp = new JScrollPane(this.text);
        this.result.setEditable(false);
        JLabel _result = new JLabel("Result:");
        this.btnEval.setBounds(0, 3, 100, 24);
        _result.setBounds(120, 3, 60, 24);
        this.result.setBounds(170, 3, 100, 24);
        this.pane.add(this.btnEval);
        this.pane.add(_result);
        this.pane.add(this.result);
        this.pane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ScriptPanel.this.enableButtons();
            }
        });
        this.add((Component)sp, "Center");
        this.add((Component)this.pane, "South");
        this.pane.setPreferredSize(new Dimension(200, 30));
        this.btnEval.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptPanel.this.eval();
            }
        });
    }

    public boolean canEval() {
        return this.text.getDocument().getLength() > 0 && this.debugPanel.isPausedState();
    }

    public void enableButtons() {
        int width = this.pane.getWidth() - this.result.getX();
        if (width > 100) {
            this.result.setSize(width, this.result.getHeight());
        }
        this.btnEval.setEnabled(this.debugPanel.isPausedState());
    }

    public void eval() {
        if (!this.canEval()) {
            return;
        }
        try {
            IValue r = this.debugPanel.debug.evalNoDebug(this.text.getText());
            this.result.setText(String.valueOf(r));
            this.debugPanel.watchPanel.notifyChanged(true);
        }
        catch (Exception ex) {
            this.debugPanel.uiMain.handleException(ex);
        }
    }

    public void changeTitle(File f) {
        this.title = f.getName();
        int index = this.parent.indexOfComponent(this);
        if (index >= 0) {
            this.parent.setTitleAt(index, f.getName());
            this.parent.setToolTipTextAt(index, f.getAbsolutePath());
        }
    }

    public void closePanel() {
        this.parent.remove(this);
    }
}

