/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.util.lightremote;

import com.kingdee.bos.util.lightremote.DefaultContext;
import com.kingdee.bos.util.lightremote.RemoteContext;
import com.kingdee.bos.util.lightremote.RemoteEnv;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class RemoteServer
extends Thread {
    static final Logger logger = Logger.getLogger(RemoteServer.class);
    public static final int DEFAULT_PORT = 10009;
    public final ServerSocket server;
    public volatile boolean closed = false;
    private volatile boolean started = false;

    public RemoteServer(int port) throws IOException {
        this.server = new ServerSocket(port);
    }

    public RemoteServer() throws IOException {
        this(10009);
    }

    protected void finalClose() {
    }

    public synchronized void waitForStart() throws InterruptedException {
        while (!this.started) {
            this.wait();
        }
        Thread.sleep(1L);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.finalClose();
    }

    @Override
    public String toString() {
        return "remote server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            logger.info((Object)(this.toString() + "(" + this.server.getLocalPort() + ") started."));
            RemoteServer remoteServer = this;
            synchronized (remoteServer) {
                this.started = true;
                this.notifyAll();
            }
            while (true) {
                final Socket sock = this.server.accept();
                RemoteEnv.startThread(new Runnable(){

                    @Override
                    public void run() {
                        RemoteServer.this.accept(sock);
                    }
                });
            }
        }
        catch (Exception ex) {
            RemoteEnv.logException(logger, ex);
            return;
        }
    }

    protected RemoteContext createContext(Socket sock) throws Exception {
        return new DefaultContext(sock);
    }

    protected void accept(Socket sock) {
        logger.info((Object)("new incoming connection " + sock));
        try {
            RemoteContext ctx = this.createContext(sock);
            ctx.serviceLoop();
        }
        catch (Exception ex) {
            RemoteEnv.logException(logger, ex);
        }
        try {
            sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info((Object)("close connection " + sock));
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            new RemoteServer().run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

