/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.biz;

import com.kingdee.bos.search.biz.IBOSSearchBizPlugin;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class BOSSearchBizPluginManager {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(BOSSearchBizPluginManager.class);
    private static Map<String, IBOSSearchBizPlugin> pluginMap = new HashMap<String, IBOSSearchBizPlugin>();

    public static void register(String bosType, IBOSSearchBizPlugin plugin) {
        pluginMap.put(bosType, plugin);
    }

    public static IBOSSearchBizPlugin get(String dc, String bosType) {
        return pluginMap.get(dc + "/" + bosType);
    }

    public static void register(String dc, String bosType, String implClassName) {
        try {
            if (StringUtils.isEmpty((String)dc) || StringUtils.isEmpty((String)bosType) || StringUtils.isEmpty((String)implClassName)) {
                return;
            }
            Class<?> clazz = Class.forName(implClassName);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Object obj = constructor.newInstance(new Object[0]);
            IBOSSearchBizPlugin plugin = (IBOSSearchBizPlugin)obj;
            pluginMap.put(dc + "/" + bosType, plugin);
        }
        catch (ClassNotFoundException e) {
            logger.error(implClassName + " not found", e);
        }
        catch (Exception e1) {
            logger.error("error", e1);
        }
        logger.info(implClassName + " register success");
    }

    public static String pluginMapView() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, IBOSSearchBizPlugin> e : pluginMap.entrySet()) {
            String s = e.getKey() + "/" + e.getValue() + "\n\r";
            sb.append(s);
        }
        return sb.toString();
    }

    public static void clear() {
        pluginMap.clear();
    }
}

