/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.biz;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.search.lucene.IndexUtil;
import com.kingdee.bos.search.lucene.LuceneEngine;
import com.kingdee.bos.search.lucene.bean.FieldMapInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class DocBuilderTool {
    public static List<Document> buildDocs(Context ctx, String bosType, String boId, List<FieldMapInfo> filedMapList, SelectorItemCollection propsAsQuery) throws Exception {
        ArrayList<Document> documents = new ArrayList<Document>();
        Map<String, String> docFieldMap = LuceneEngine.getEngine(ctx.getAIS()).bizPlugin().getCustomDocFieldMap(ctx, bosType, boId);
        List<Field> fieldList = IndexUtil.getQueryConditionValue(ctx, propsAsQuery, boId);
        fieldList.addAll(DocBuilderTool.mapToFiedList(docFieldMap));
        for (FieldMapInfo info : filedMapList) {
            Document doc = new Document();
            StringField idField = null;
            String eId = info.getEntryId();
            StringField bizId = new StringField("o_id", info.getOwnerId(), Field.Store.YES);
            if (eId == null) {
                eId = "";
                idField = new StringField("id", info.getOwnerId(), Field.Store.YES);
            } else {
                idField = new StringField("id", eId, Field.Store.YES);
            }
            StringField entryId = new StringField("e_id", eId, Field.Store.YES);
            StringField btype = new StringField("bosType", info.getBosType(), Field.Store.YES);
            StringField isEntry = new StringField("isEntry", String.valueOf(info.isEntry()), Field.Store.YES);
            StringField billName = new StringField("billName", String.valueOf(info.getBillName()), Field.Store.YES);
            String json = JSON.toJSONString(info.getProps());
            TextField docValue = new TextField("docVal", json, Field.Store.YES);
            doc.add((IndexableField)idField);
            doc.add((IndexableField)entryId);
            doc.add((IndexableField)btype);
            doc.add((IndexableField)isEntry);
            doc.add((IndexableField)billName);
            doc.add((IndexableField)docValue);
            doc.add((IndexableField)bizId);
            if (fieldList != null) {
                for (Field f : fieldList) {
                    doc.add((IndexableField)f);
                }
            }
            documents.add(doc);
        }
        return documents;
    }

    public static List<Document> buildDocs(Map<String, String> map) {
        List<Field> fl = DocBuilderTool.mapToFiedList(map);
        Document doc = new Document();
        for (Field f : fl) {
            doc.add((IndexableField)f);
        }
        ArrayList<Document> docs = new ArrayList<Document>();
        docs.add(doc);
        return docs;
    }

    private static List<Field> mapToFiedList(Map<String, String> map) {
        ArrayList<Field> list = new ArrayList<Field>();
        if (map == null || map.size() == 0) {
            return list;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            TextField field = new TextField(entry.getKey(), entry.getValue(), Field.Store.YES);
            list.add((Field)field);
        }
        return list;
    }
}

