/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.biz;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.search.biz.IDocumentBuilder;
import com.kingdee.bos.search.lucene.IndexUtil;
import com.kingdee.bos.search.lucene.bean.FieldBizType;
import com.kingdee.bos.search.lucene.bean.KSField;
import com.kingdee.bos.search.lucene.bean.LuceneBizId;
import com.kingdee.bos.search.lucene.bean.SearchBizCfg;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.enums.DynamicEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;

public class DocumentBuilder
implements IDocumentBuilder {
    private Context ctx;
    private SearchBizCfg bizcfg;
    private Map<String, PropertyCollection> propMap = new HashMap<String, PropertyCollection>();
    private SelectorItemCollection propsToIndexSelector;
    private EntityObjectInfo entityInfo;

    public DocumentBuilder(Context ctx, SearchBizCfg bizcfg) {
        this.bizcfg = bizcfg;
        this.ctx = ctx;
        this.propsToIndexSelector = bizcfg.getSelectColl();
        this.entityInfo = IndexUtil.getEntityObj(ctx, bizcfg.getBosType());
    }

    @Override
    public Map<String, Object> buildMap(LuceneBizId biz) throws Exception {
        String boId = biz.getBizId();
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        this.buildFiledMap(this.ctx, fieldMap, boId, this.propsToIndexSelector);
        return fieldMap;
    }

    @Override
    public List<Document> buildDocs(LuceneBizId biz) throws Exception {
        return null;
    }

    public void buildFiledMap(Context ctx, Map<String, Object> fieldMap, String ownerId, SelectorItemCollection propsToIndexSelector) throws Exception {
        Object o = IndexUtil.boVal(ctx, ownerId, propsToIndexSelector);
        fieldMap.put("id", ownerId);
        PropertyContainer container = (PropertyContainer)o;
        for (KSField f : this.bizcfg.getFields()) {
            if (f.isEntry()) {
                int index = f.getName().indexOf(".");
                AbstractObjectCollection collect = (AbstractObjectCollection)container.get(f.getName().substring(0, index));
                int size = collect.size();
                if (size > 500) {
                    size = 500;
                }
                Object[] objs = new Object[size];
                for (int i = 0; i < size; ++i) {
                    objs[i] = this.getPropVal((PropertyContainer)collect.getObject(i), f.getName().substring(index + 1, f.getName().length()), f.isF7());
                }
                fieldMap.put(f.getName(), objs);
                continue;
            }
            if ("Enum".equals(f.getDataType())) {
                String val = this.getPropVal(container, f.getName(), f.isF7());
                PropertyInfo prop = this.entityInfo.getPropertyByNameRuntime(f.getName());
                OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                String enumPk = ownProp.getMetaDataRef();
                DynamicEnum dyEnum = DynamicEnum.getEnum((String)enumPk, (Object)val.toString());
                if (dyEnum != null) {
                    val = dyEnum.getAlias();
                }
                if (val == null) continue;
                fieldMap.put(f.getName(), val);
                continue;
            }
            String val = this.getPropVal(container, f.getName(), f.isF7());
            fieldMap.put(f.getName(), val);
        }
    }

    private String getPropVal(PropertyContainer container, String fname, boolean isF7) {
        if (isF7) {
            PropertyContainer c2 = (PropertyContainer)container.get(fname);
            if (c2 == null) {
                return "";
            }
            String id = c2.get("id").toString();
            Object o = c2.get("name");
            if (o == null) {
                PropertyContainer f7Obj = this.getF7(id);
                String name = f7Obj.get("name").toString();
                String number = f7Obj.get("number").toString();
                return FieldBizType.$F7$.name() + ":" + id + ";" + name + ";" + number;
            }
            String name = o == null ? "" : o.toString();
            String number = c2.get("number").toString();
            return FieldBizType.$F7$.name() + ":" + id + ";" + name + ";" + number;
        }
        Object obj = container.get(fname);
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    private PropertyContainer getF7(String id) {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("name");
        selectors.add("number");
        try {
            Object val = IndexUtil.boVal(this.ctx, id.toString(), selectors);
            return (PropertyContainer)val;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private PropertyCollection getProps(Context ctx, String bosType) {
        EntityObjectInfo entryEntity = IndexUtil.getEntityObj(ctx, bosType);
        PropertyCollection propColls = entryEntity.getInheritedNoDuplicatedProperties();
        this.propMap.put(bosType, propColls);
        return propColls;
    }
}

