/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.dao;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.search.db.DbClient;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.bean.KSField;
import com.kingdee.bos.search.lucene.bean.SearchBizCfg;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SearchBizCfgDAO {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(SearchBizCfgDAO.class);
    public static SearchBizCfgDAO INS = new SearchBizCfgDAO();

    private SearchBizCfgDAO() {
    }

    public List<SearchBizCfg> load(String dc) throws SQLException, IOException {
        String sql = "select * from T_LUCENE_BIZCFG";
        ArrayList cfgs = DbClient.query(dc, sql);
        return this.loadBizCfgInner(cfgs);
    }

    public SearchBizCfg loadByBosType(String dc, String bosType) throws SQLException, IOException {
        String sql = "select * from T_LUCENE_BIZCFG where fbostype=?";
        ArrayList cfgs = DbClient.query(dc, sql, new int[]{12}, new Object[]{bosType});
        List<SearchBizCfg> bizCfgs = this.loadBizCfgInner(cfgs);
        SearchBizCfg searchBizCfg = null;
        if (bizCfgs.size() > 0) {
            searchBizCfg = bizCfgs.get(0);
        }
        return searchBizCfg;
    }

    public boolean isExistCfg(String dc, String bosType) throws SQLException, IOException {
        String sql = "select * from T_LUCENE_BIZCFG where fbostype=?";
        ArrayList cfgs = DbClient.query(dc, sql, new int[]{12}, new Object[]{bosType});
        boolean isExist = false;
        if (cfgs.size() > 0) {
            isExist = true;
        }
        return isExist;
    }

    private List<SearchBizCfg> loadBizCfgInner(List<?> cfgs) {
        ArrayList<SearchBizCfg> bizCfgs = new ArrayList<SearchBizCfg>();
        for (Object obj : cfgs) {
            String bostype = (String)((Map)obj).get("fbostype");
            String bizName = (String)((Map)obj).get("fbizname");
            String jsonProps = (String)((Map)obj).get("fbillfields");
            String implClass = (String)((Map)obj).get("fimplclass");
            boolean enable = ((Map)obj).get("fenable").toString().equals("1");
            String bizCreateTimeField = (String)((Map)obj).get("fbiztimefield");
            String packageName = (String)((Map)obj).get("fbillpackage");
            Object o = ((Map)obj).get("fstate");
            int state = o == null ? 0 : Integer.valueOf(o.toString());
            Timestamp starttime = (Timestamp)((Map)obj).get("fstarttime");
            bizCfgs.add(new SearchBizCfg(bostype, bizName, bizCreateTimeField, packageName, state, implClass, this.parseJson(jsonProps), enable, starttime));
        }
        return bizCfgs;
    }

    public List<KSField> load(String dc, String bosType) throws SQLException, IOException {
        String sql = "select fbillfields from T_LUCENE_BIZCFG where fbostype =?";
        ArrayList cfgs = DbClient.query(dc, sql, new int[]{12}, new Object[]{bosType});
        Iterator iterator = cfgs.iterator();
        if (iterator.hasNext()) {
            Object obj = iterator.next();
            String jsonProps = (String)((Map)obj).get("fbillfields");
            return this.parseJson(jsonProps);
        }
        return null;
    }

    public void delete(String dc, String bosType) throws SQLException {
        String sql = "delete from T_LUCENE_BIZCFG where fbostype =?";
        DbClient.update(dc, sql, new int[]{12}, new Object[]{bosType});
    }

    public void add(String dc, SearchBizCfg cfg) throws SQLException {
        String sql = "insert into T_LUCENE_BIZCFG (fid,fbostype,fbizname,fenable,fbillfields,fbiztimefield,fbillpackage,fstate,fstarttime) values(?,?,?,?,?,?,?,?,?)";
        String jsonProps = this.toJson(cfg.getFields());
        DbClient.update(dc, sql, new int[]{12, 12, 12, 12, 12, 12, 12, 4, 93}, new Object[]{cfg.getId(), cfg.getBosType(), cfg.getBizName(), cfg.isEnable() ? "1" : "0", jsonProps, cfg.getBizCreateTimeField(), cfg.getPackageName(), cfg.getState(), cfg.getStartTime()});
    }

    public void updateBizFields(String dc, String bosType, List<KSField> fields, String bizCreateTimeField) throws SQLException {
        String sql = "update T_LUCENE_BIZCFG set fbillfields = ?,fbiztimefield=?,fstate=2 where fbostype =?";
        DbClient.update(dc, sql, new int[]{12, 12, 12}, new Object[]{this.toJson(fields), bizCreateTimeField, bosType});
    }

    public void disable(String dc, String bosType) throws SQLException {
        String sql = "update T_LUCENE_BIZCFG set fenable = 0 where fbostype = ?";
        DbClient.update(dc, sql, new int[]{12}, new Object[]{bosType});
    }

    public void enable(String dc, String bosType) throws SQLException {
        String sql = "update T_LUCENE_BIZCFG set fenable = 1 where fbostype = ?";
        DbClient.update(dc, sql, new int[]{12}, new Object[]{bosType});
    }

    private String toJson(List<KSField> fields) {
        return JSON.toJSONString(fields);
    }

    private List<KSField> parseJson(String jsonProps) {
        return JSON.parseArray((String)jsonProps, KSField.class);
    }
}

