/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.ksconnection;

import com.kingdee.bos.search.ksconnection.KSearchConnection;
import com.kingdee.bos.search.lucene.bean.PageResult;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import com.kingdee.bos.search.lucene.bean.SearchResult;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;

public abstract class AbstractKSConnection
implements KSearchConnection {
    protected Integer connTimeoutMillis = 120000;
    protected volatile long activeTimeStamp = 0L;

    @Override
    public List<Map<String, Object>> query(SearchParam param) throws Exception {
        this.reset();
        return this.innerQuery(param);
    }

    @Override
    public PageResult pageQuery(SearchParam param) throws Exception {
        this.reset();
        return this.innerPageQuery(param);
    }

    @Override
    public List<SearchResult> query4BillInfo(SearchParam param) throws Exception {
        this.reset();
        return this.innerQuery4BillInfo(param);
    }

    @Override
    public void updateDoc(String dc, String bosType, Map<String, Object> map) throws Exception {
        this.reset();
        this.innerUpdateDoc(dc, bosType, map);
    }

    @Override
    public void deleteDocs(String dc, String bosType, List<String> ids) throws Exception {
        this.reset();
        this.innerDeleteDoc(dc, bosType, ids);
    }

    @Override
    public void deleteDoc(String dc, String bosType, String field, String value) throws Exception {
        this.reset();
        this.innerDeleteDoc(dc, bosType, field, value);
    }

    @Override
    public void updateDoc(String dc, String bosType, List<Document> documents) throws Exception {
        this.reset();
        this.innerUpdateDoc(dc, bosType, documents);
    }

    @Override
    public void updateDocs(String dc, String bosType, List<Map<String, Object>> maps) throws Exception {
        this.reset();
        this.innerUpdateDocs(dc, bosType, maps);
    }

    @Override
    public boolean isValid() {
        long now = System.currentTimeMillis();
        return now - this.activeTimeStamp <= (long)this.connTimeoutMillis.intValue();
    }

    private void reset() {
        this.activeTimeStamp = System.currentTimeMillis();
    }

    @Override
    public void init() {
    }

    @Override
    public void close() {
    }

    public String getMainQuery(SearchParam searchParam) {
        if (searchParam.getMainQuerys() == null) {
            if (searchParam.getField() == null) {
                return searchParam.getKeyword();
            }
            return searchParam.getField() + ":" + searchParam.getKeyword();
        }
        StringBuilder sb = new StringBuilder();
        Map<String, String> map = searchParam.getMainQuerys();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String val = entry.getValue();
            if (StringUtils.isEmpty((String)val)) continue;
            if (sb.length() != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey() + ":" + val);
        }
        return sb.toString();
    }

    public String[] getFilterQuery(SearchParam searchParam) {
        if (searchParam.getQueryCondition() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Map<String, String> map = searchParam.getQueryCondition();
        String[] queries = new String[map.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (sb.length() != 0) {
                sb.append(" AND ");
            }
            queries[i++] = entry.getKey() + ":" + entry.getValue();
        }
        return queries;
    }

    protected abstract List<Map<String, Object>> innerQuery(SearchParam var1) throws Exception;

    protected abstract PageResult innerPageQuery(SearchParam var1) throws Exception;

    protected abstract List<SearchResult> innerQuery4BillInfo(SearchParam var1) throws Exception;

    protected abstract void innerUpdateDoc(String var1, String var2, Map<String, Object> var3) throws Exception;

    protected abstract void innerDeleteDoc(String var1, String var2, List<String> var3) throws Exception;

    protected abstract void innerDeleteDoc(String var1, String var2, String var3, String var4) throws Exception;

    protected abstract void innerUpdateDoc(String var1, String var2, List<Document> var3) throws Exception;

    protected abstract void innerUpdateDocs(String var1, String var2, List<Map<String, Object>> var3) throws Exception;
}

