/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.ksconnection;

import bos.org.apache.commons.pool.KeyedPoolableObjectFactory;
import bos.org.apache.commons.pool.impl.GenericKeyedObjectPool;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;

public class KSPool
implements Closeable {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(KSPool.class);
    protected GenericKeyedObjectPool internalPool;

    public KSPool(KeyedPoolableObjectFactory poolableObjectFactory) {
        this.initPool(poolableObjectFactory);
    }

    public Object getResource(Object key) throws Exception {
        return this.internalPool.borrowObject(key);
    }

    protected void returnResourceObject(Object key, Object resource) throws Exception {
        if (resource == null) {
            return;
        }
        this.internalPool.returnObject(key, resource);
    }

    public void returnBrokenResource(Object key, Object resource) throws Exception {
        if (resource != null) {
            this.returnBrokenResourceObject(key, resource);
        }
    }

    public void returnResource(Object key, Object resource) throws Exception {
        if (resource != null) {
            this.returnResourceObject(key, resource);
        }
    }

    public void destroy() throws Exception {
        this.closeInternalPool();
    }

    protected void returnBrokenResourceObject(Object key, Object resource) throws Exception {
        this.internalPool.invalidateObject(key, resource);
    }

    protected void closeInternalPool() throws Exception {
        this.internalPool.close();
    }

    public int getNumActive() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumActive();
    }

    public int getNumIdle() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumIdle();
    }

    private void initPool(KeyedPoolableObjectFactory factory) {
        if (this.internalPool != null) {
            try {
                this.closeInternalPool();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.internalPool = new GenericKeyedObjectPool(factory);
        this.internalPool.setWhenExhaustedAction((byte)2);
    }

    public void addObjects(Object key, int count) throws Exception {
        try {
            for (int i = 0; i < count; ++i) {
                this.internalPool.addObject(key);
            }
        }
        catch (Exception e) {
            throw new Exception("Error trying to add idle objects", e);
        }
    }

    private boolean poolInactive() {
        return this.internalPool == null;
    }

    @Override
    public void close() throws IOException {
        try {
            this.destroy();
        }
        catch (Exception e) {
            throw new IOException("close error", e);
        }
    }
}

