/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.search.ksconnection;

import com.kingdee.bos.search.ksconnection.AbstractKSConnection;
import com.kingdee.bos.search.log.Logger;
import com.kingdee.bos.search.log.LoggerFactory;
import com.kingdee.bos.search.lucene.QueryBuilder;
import com.kingdee.bos.search.lucene.bean.KSField;
import com.kingdee.bos.search.lucene.bean.PageResult;
import com.kingdee.bos.search.lucene.bean.SearchParam;
import com.kingdee.bos.search.lucene.bean.SearchResult;
import com.kingdee.bos.search.lucene.tool.KSFieldCache;
import com.kingdee.bos.search.msic.Tool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

public class SolrConnection
extends AbstractKSConnection {
    protected static final Logger logger = LoggerFactory.REF.get().getLogger(SolrConnection.class);
    private String path;
    private SolrClient solrClient;

    public SolrConnection(String path) {
        this.path = path;
    }

    @Override
    public void init() {
        this.solrClient = ((HttpSolrClient.Builder)new HttpSolrClient.Builder(this.path).withSocketTimeout(this.connTimeoutMillis.intValue())).build();
        this.activeTimeStamp = System.currentTimeMillis();
    }

    @Override
    public void close() {
    }

    @Override
    protected List<Map<String, Object>> innerQuery(SearchParam searchParam) throws Exception {
        QueryResponse response = this.solorQuery(searchParam);
        return this.dealQueryResult(response, searchParam);
    }

    private QueryResponse solorQuery(SearchParam searchParam) throws IOException, SolrServerException {
        SolrQuery query = this.buildQuery(searchParam);
        query.setSort(searchParam.getSortFiled(), searchParam.isDesc() ? SolrQuery.ORDER.desc : SolrQuery.ORDER.asc);
        query.setRows(Integer.valueOf(searchParam.getTop()));
        if (searchParam.getStart() != null) {
            query.setStart(searchParam.getStart());
        }
        return this.solrClient.query(searchParam.getDc() + "_" + searchParam.getBosType(), (SolrParams)query);
    }

    private List<Map<String, Object>> dealQueryResult(QueryResponse response, SearchParam searchParam) {
        ArrayList<Map<String, Object>> listResult = new ArrayList<Map<String, Object>>();
        SolrDocumentList documents = response.getResults();
        Map highlightMap = null;
        if (searchParam.getHighlightField() != null) {
            highlightMap = response.getHighlighting();
        }
        if (searchParam.isNotFilterFields() || searchParam.getReturnFields() != null && searchParam.getReturnFields().size() > 0) {
            for (SolrDocument document : documents) {
                HashMap<String, Object> results = new HashMap<String, Object>();
                for (String fieldName : document.keySet()) {
                    if ("_version_".equals(fieldName) || !searchParam.isNotFilterFields() && !searchParam.getReturnFields().contains(fieldName)) continue;
                    if (fieldName.equals(searchParam.getHighlightField())) {
                        String id = document.getFirstValue("id").toString();
                        results.put(fieldName, ((Map)highlightMap.get(id)).get(fieldName));
                        continue;
                    }
                    Object firstValue = document.getFirstValue(fieldName);
                    if (firstValue instanceof Date) {
                        Date date1 = (Date)firstValue;
                        firstValue = new Date(date1.getTime() - 28800000L);
                    }
                    results.put(fieldName, firstValue);
                }
                listResult.add(results);
            }
            return listResult;
        }
        List<KSField> ksFields = KSFieldCache.INS.load(searchParam.getDc(), searchParam.getBosType());
        for (SolrDocument document : documents) {
            HashMap<String, Object> results = new HashMap<String, Object>();
            for (KSField ksField : ksFields) {
                if (ksField.getName().equals(searchParam.getHighlightField())) {
                    String id = document.getFirstValue("id").toString();
                    results.put(ksField.getName(), ((Map)highlightMap.get(id)).get(ksField.getName()));
                    continue;
                }
                Object value = document.getFirstValue(ksField.getName());
                if (value instanceof Date) {
                    Date date1 = (Date)value;
                    value = new Date(date1.getTime() - 28800000L);
                }
                results.put(ksField.getName(), value);
            }
            listResult.add(results);
        }
        return listResult;
    }

    @Override
    protected PageResult innerPageQuery(SearchParam searchParam) throws Exception {
        QueryResponse queryResponse = this.solorQuery(searchParam);
        long count = 0L;
        if (queryResponse != null && queryResponse.getResults() != null) {
            count = queryResponse.getResults().getNumFound();
        }
        List<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        if (queryResponse != null) {
            dataList = this.dealQueryResult(queryResponse, searchParam);
        }
        return new PageResult().setDataList(dataList).setCount(count).setStart(searchParam.getStart()).setTop(searchParam.getTop());
    }

    @Override
    protected void innerUpdateDoc(String dc, String bosType, Map<String, Object> map) throws Exception {
        if (map.size() == 0) {
            return;
        }
        SolrInputDocument solrDoc = this.buildSolrDoc(map);
        this.solrClient.add(dc + "_" + bosType, solrDoc);
    }

    private SolrInputDocument buildSolrDoc(Map<String, Object> map) {
        SolrInputDocument solrDoc = new SolrInputDocument(new String[0]);
        for (Map.Entry<String, Object> doc : map.entrySet()) {
            String k = doc.getKey();
            Object v = doc.getValue();
            solrDoc.addField(k, v);
        }
        return solrDoc;
    }

    @Override
    public void innerUpdateDocs(String dc, String bosType, List<Map<String, Object>> maps) throws Exception {
        if (maps.size() == 0) {
            return;
        }
        ArrayList<SolrInputDocument> solrDocs = new ArrayList<SolrInputDocument>();
        for (int i = 0; i < maps.size(); ++i) {
            solrDocs.add(this.buildSolrDoc(maps.get(i)));
        }
        this.solrClient.add(dc + "_" + bosType, solrDocs);
    }

    @Override
    protected void innerDeleteDoc(String dc, String bosType, List<String> ids) throws Exception {
        this.solrClient.deleteById(dc + "_" + bosType, ids);
    }

    @Override
    protected void innerDeleteDoc(String dc, String bosType, String field, String value) throws Exception {
        String query = field + ":" + value;
        if (field == null || "".equals(field.trim())) {
            query = value;
        }
        this.solrClient.deleteByQuery(dc + "_" + bosType, query);
    }

    @Override
    protected void innerUpdateDoc(String dc, String bosType, List<Document> documents) throws Exception {
        if (documents.size() == 0) {
            return;
        }
        ArrayList<SolrInputDocument> solrDocs = new ArrayList<SolrInputDocument>();
        SolrInputDocument solrDoc = null;
        for (Document doc : documents) {
            solrDoc = new SolrInputDocument(new String[0]);
            for (IndexableField field : doc) {
                solrDoc.addField(field.name(), (Object)field.stringValue());
            }
            solrDocs.add(solrDoc);
        }
        this.solrClient.add(dc + "_" + bosType, solrDocs);
    }

    @Override
    protected List<SearchResult> innerQuery4BillInfo(SearchParam searchParam) throws Exception {
        SolrQuery query = this.buildSolrQuery(searchParam);
        QueryResponse response = this.solrClient.query(searchParam.getDc() + "_" + searchParam.getBosType(), (SolrParams)query);
        SolrDocumentList solrDocuments = response.getResults();
        Map highlightMap = response.getHighlighting();
        HashMap<String, String> idToHighlightDocValMap = new HashMap<String, String>();
        ArrayList<Map<String, String>> docMaps = new ArrayList<Map<String, String>>();
        for (String key : highlightMap.keySet()) {
            String doc = (String)((List)((Map)highlightMap.get(key)).get("docVal")).get(0);
            idToHighlightDocValMap.put(key, doc);
        }
        for (SolrDocument document : solrDocuments) {
            docMaps.add(this.solrDocToMap(document, idToHighlightDocValMap));
        }
        Query luceneQuery = QueryBuilder.normalQuery(searchParam);
        return Tool.getSearchResult(luceneQuery, searchParam, docMaps);
    }

    private SolrQuery buildSolrQuery(SearchParam searchParam) {
        SolrQuery query = new SolrQuery("docVal:" + searchParam.getKeyword());
        String[] filterQuery = this.getFilterQuery(searchParam);
        query.setFilterQueries(filterQuery);
        query.setRows(Integer.valueOf(searchParam.getTop()));
        query.setHighlight(true);
        query.addHighlightField("docVal");
        query.setHighlightSimplePre("<Strong>");
        query.setHighlightSimplePost("</Strong>");
        query.setHighlightFragsize(0);
        if (searchParam.isDebug()) {
            query.setShowDebugInfo(true);
            query.set("debug.explain.structured", new String[]{"true"});
        }
        return query;
    }

    private Map<String, String> solrDocToMap(SolrDocument doc, Map<String, String> idToHighlightDocValMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", doc.getFirstValue("id").toString());
        map.put("o_id", doc.getFirstValue("o_id").toString());
        map.put("bosType", doc.getFirstValue("bosType").toString());
        String entryID = "";
        if (doc.getFirstValue("e_id") != null) {
            entryID = doc.getFirstValue("e_id").toString();
        }
        map.put("e_id", entryID);
        map.put("isEntry", doc.getFirstValue("isEntry").toString());
        String name = "";
        if (doc.getFirstValue("billName") != null) {
            name = doc.getFirstValue("billName").toString();
        }
        map.put("billName", name);
        map.put("docVal", idToHighlightDocValMap.get(map.get("id")));
        return map;
    }

    private SolrQuery buildQuery(SearchParam searchParam) {
        String mainQuery = this.getMainQuery(searchParam);
        String[] filterQuery = this.getFilterQuery(searchParam);
        SolrQuery query = new SolrQuery(mainQuery);
        query.setFilterQueries(filterQuery);
        if (searchParam.getHighlightField() != null) {
            query.setHighlight(true);
            query.addHighlightField(searchParam.getHighlightField());
            query.setHighlightSimplePre("<font color=\"#FF0000\">");
            query.setHighlightSimplePost("</font>");
            query.setHighlightFragsize(0);
        }
        return query;
    }

    @Override
    public void addEasLog(List<Map<String, Object>> logInfos) {
        ArrayList<SolrInputDocument> solrDocs = new ArrayList<SolrInputDocument>();
        for (int i = 0; i < logInfos.size(); ++i) {
            solrDocs.add(this.buildSolrDoc(logInfos.get(i)));
        }
        try {
            this.solrClient.add(solrDocs);
        }
        catch (Exception e) {
            logger.error("error", e);
        }
    }

    @Override
    public void addEasLog(List<Map<String, Object>> logInfos, String dc, String bosType) {
        ArrayList<SolrInputDocument> solrDocs = new ArrayList<SolrInputDocument>();
        for (int i = 0; i < logInfos.size(); ++i) {
            solrDocs.add(this.buildSolrDoc(logInfos.get(i)));
        }
        try {
            this.solrClient.add(dc + "_" + bosType, solrDocs);
        }
        catch (Exception e) {
            logger.error("error", e);
        }
    }
}

